/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.persistence.TspSolutionFileIO;

public class TspExporter
extends AbstractTxtSolutionExporter<TspSolution> {
    public static final String OUTPUT_FILE_SUFFIX = "tour";

    public static void main(String[] args) {
        SolutionConverter<TspSolution> converter = SolutionConverter.createExportConverter("tsp", new TspExporter(), new TspSolutionFileIO());
        converter.convertAll();
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<TspSolution> createTxtOutputBuilder() {
        return new TspOutputBuilder();
    }

    public static class TspOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<TspSolution> {
        @Override
        public void writeSolution() throws IOException {
            this.bufferedWriter.write("NAME : " + ((TspSolution)this.solution).getName() + "\n");
            this.bufferedWriter.write("TYPE : TOUR\n");
            this.bufferedWriter.write("DIMENSION : " + ((TspSolution)this.solution).getLocationList().size() + "\n");
            this.bufferedWriter.write("TOUR_SECTION\n");
            AbstractPersistable standstill = ((TspSolution)this.solution).getDomicile();
            while (standstill != null) {
                this.bufferedWriter.write(standstill.getLocation().getId() + "\n");
                standstill = this.findNextVisit((Standstill)((Object)standstill));
            }
            this.bufferedWriter.write("EOF\n");
        }

        private Visit findNextVisit(Standstill standstill) {
            for (Visit visit : ((TspSolution)this.solution).getVisitList()) {
                if (visit.getPreviousStandstill() != standstill) continue;
                return visit;
            }
            return null;
        }
    }
}

