/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;

public abstract class AbstractTuple
implements Tuple {
    private final boolean storeIsArray;
    private Object store;
    public BavetTupleState state = BavetTupleState.CREATING;

    protected AbstractTuple(int storeSize) {
        this.store = storeSize < 2 ? null : new Object[storeSize];
        this.storeIsArray = this.store != null;
    }

    @Override
    public final BavetTupleState getState() {
        return this.state;
    }

    @Override
    public final void setState(BavetTupleState state) {
        this.state = state;
    }

    @Override
    public final <Value_> Value_ getStore(int index) {
        if (this.storeIsArray) {
            return (Value_)((Object[])this.store)[index];
        }
        return (Value_)this.store;
    }

    @Override
    public final void setStore(int index, Object value) {
        if (this.storeIsArray) {
            ((Object[])this.store)[index] = value;
            return;
        }
        this.store = value;
    }

    @Override
    public <Value_> Value_ removeStore(int index) {
        Object value;
        if (this.storeIsArray) {
            Object[] array = (Object[])this.store;
            value = array[index];
            array[index] = null;
        } else {
            value = this.store;
            this.store = null;
        }
        return (Value_)value;
    }
}

