/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.stream.ConstraintJustification;

public interface ScoreExplanation<Solution_, Score_ extends Score<Score_>> {
    public Solution_ getSolution();

    public Score_ getScore();

    public String getSummary();

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap();

    public List<ConstraintJustification> getJustificationList();

    default public <ConstraintJustification_ extends ConstraintJustification> List<ConstraintJustification_> getJustificationList(Class<? extends ConstraintJustification_> constraintJustificationClass) {
        return this.getJustificationList().stream().filter(constraintJustification -> constraintJustificationClass.isAssignableFrom(constraintJustification.getClass())).map(constraintJustification -> constraintJustification).collect(Collectors.toList());
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap();
}

