/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic.placer;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;

@XmlType(propOrder={"entitySelectorConfig", "moveSelectorConfigList"})
public class QueuedEntityPlacerConfig
extends EntityPlacerConfig<QueuedEntityPlacerConfig> {
    @XmlElement(name="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    @XmlElements(value={@XmlElement(name="cartesianProductMoveSelector", type=CartesianProductMoveSelectorConfig.class), @XmlElement(name="changeMoveSelector", type=ChangeMoveSelectorConfig.class), @XmlElement(name="moveIteratorFactory", type=MoveIteratorFactoryConfig.class), @XmlElement(name="moveListFactory", type=MoveListFactoryConfig.class), @XmlElement(name="pillarChangeMoveSelector", type=PillarChangeMoveSelectorConfig.class), @XmlElement(name="pillarSwapMoveSelector", type=PillarSwapMoveSelectorConfig.class), @XmlElement(name="subChainChangeMoveSelector", type=SubChainChangeMoveSelectorConfig.class), @XmlElement(name="subChainSwapMoveSelector", type=SubChainSwapMoveSelectorConfig.class), @XmlElement(name="swapMoveSelector", type=SwapMoveSelectorConfig.class), @XmlElement(name="tailChainSwapMoveSelector", type=TailChainSwapMoveSelectorConfig.class), @XmlElement(name="unionMoveSelector", type=UnionMoveSelectorConfig.class)})
    protected List<MoveSelectorConfig> moveSelectorConfigList = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public QueuedEntityPlacerConfig withEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.setEntitySelectorConfig(entitySelectorConfig);
        return this;
    }

    public QueuedEntityPlacerConfig withMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.setMoveSelectorConfigList(moveSelectorConfigList);
        return this;
    }

    public QueuedEntityPlacerConfig withMoveSelectorConfigs(MoveSelectorConfig ... moveSelectorConfigs) {
        return this.withMoveSelectorConfigList(Arrays.asList(moveSelectorConfigs));
    }

    @Override
    public QueuedEntityPlacerConfig inherit(QueuedEntityPlacerConfig inheritedConfig) {
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        return this;
    }

    @Override
    public QueuedEntityPlacerConfig copyConfig() {
        return new QueuedEntityPlacerConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.entitySelectorConfig != null) {
            this.entitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.moveSelectorConfigList != null) {
            this.moveSelectorConfigList.forEach(ms -> ms.visitReferencedClasses(classVisitor));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.moveSelectorConfigList + ")";
    }
}

