/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.common.nearby;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionDistributionType;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;

@XmlType(propOrder={"originEntitySelectorConfig", "nearbyDistanceMeterClass", "nearbySelectionDistributionType", "blockDistributionSizeMinimum", "blockDistributionSizeMaximum", "blockDistributionSizeRatio", "blockDistributionUniformDistributionProbability", "linearDistributionSizeMaximum", "parabolicDistributionSizeMaximum", "betaDistributionAlpha", "betaDistributionBeta"})
public class NearbySelectionConfig
extends SelectorConfig<NearbySelectionConfig> {
    @XmlElement(name="originEntitySelector")
    protected EntitySelectorConfig originEntitySelectorConfig = null;
    protected Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass = null;
    protected NearbySelectionDistributionType nearbySelectionDistributionType = null;
    protected Integer blockDistributionSizeMinimum = null;
    protected Integer blockDistributionSizeMaximum = null;
    protected Double blockDistributionSizeRatio = null;
    protected Double blockDistributionUniformDistributionProbability = null;
    protected Integer linearDistributionSizeMaximum = null;
    protected Integer parabolicDistributionSizeMaximum = null;
    protected Double betaDistributionAlpha = null;
    protected Double betaDistributionBeta = null;

    public EntitySelectorConfig getOriginEntitySelectorConfig() {
        return this.originEntitySelectorConfig;
    }

    public void setOriginEntitySelectorConfig(EntitySelectorConfig originEntitySelectorConfig) {
        this.originEntitySelectorConfig = originEntitySelectorConfig;
    }

    public Class<? extends NearbyDistanceMeter> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    public NearbySelectionDistributionType getNearbySelectionDistributionType() {
        return this.nearbySelectionDistributionType;
    }

    public void setNearbySelectionDistributionType(NearbySelectionDistributionType nearbySelectionDistributionType) {
        this.nearbySelectionDistributionType = nearbySelectionDistributionType;
    }

    public Integer getBlockDistributionSizeMinimum() {
        return this.blockDistributionSizeMinimum;
    }

    public void setBlockDistributionSizeMinimum(Integer blockDistributionSizeMinimum) {
        this.blockDistributionSizeMinimum = blockDistributionSizeMinimum;
    }

    public Integer getBlockDistributionSizeMaximum() {
        return this.blockDistributionSizeMaximum;
    }

    public void setBlockDistributionSizeMaximum(Integer blockDistributionSizeMaximum) {
        this.blockDistributionSizeMaximum = blockDistributionSizeMaximum;
    }

    public Double getBlockDistributionSizeRatio() {
        return this.blockDistributionSizeRatio;
    }

    public void setBlockDistributionSizeRatio(Double blockDistributionSizeRatio) {
        this.blockDistributionSizeRatio = blockDistributionSizeRatio;
    }

    public Double getBlockDistributionUniformDistributionProbability() {
        return this.blockDistributionUniformDistributionProbability;
    }

    public void setBlockDistributionUniformDistributionProbability(Double blockDistributionUniformDistributionProbability) {
        this.blockDistributionUniformDistributionProbability = blockDistributionUniformDistributionProbability;
    }

    public Integer getLinearDistributionSizeMaximum() {
        return this.linearDistributionSizeMaximum;
    }

    public void setLinearDistributionSizeMaximum(Integer linearDistributionSizeMaximum) {
        this.linearDistributionSizeMaximum = linearDistributionSizeMaximum;
    }

    public Integer getParabolicDistributionSizeMaximum() {
        return this.parabolicDistributionSizeMaximum;
    }

    public void setParabolicDistributionSizeMaximum(Integer parabolicDistributionSizeMaximum) {
        this.parabolicDistributionSizeMaximum = parabolicDistributionSizeMaximum;
    }

    public Double getBetaDistributionAlpha() {
        return this.betaDistributionAlpha;
    }

    public void setBetaDistributionAlpha(Double betaDistributionAlpha) {
        this.betaDistributionAlpha = betaDistributionAlpha;
    }

    public Double getBetaDistributionBeta() {
        return this.betaDistributionBeta;
    }

    public void setBetaDistributionBeta(Double betaDistributionBeta) {
        this.betaDistributionBeta = betaDistributionBeta;
    }

    public void validateNearby(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        if (this.originEntitySelectorConfig == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection but lacks an originEntitySelectorConfig (" + this.originEntitySelectorConfig + ").");
        }
        if (this.originEntitySelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has an originEntitySelectorConfig (" + this.originEntitySelectorConfig + ") which has no MimicSelectorRef (" + this.originEntitySelectorConfig.getMimicSelectorRef() + "). A nearby's original entity should always be the same as an entity selected earlier in the move.");
        }
        if (this.nearbyDistanceMeterClass == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection but lacks a nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ").");
        }
        if (resolvedSelectionOrder != SelectionOrder.ORIGINAL && resolvedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with nearbyOriginEntitySelector (" + this.originEntitySelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.ORIGINAL + " or " + SelectionOrder.RANDOM + ".");
        }
        if (resolvedCacheType.isCached()) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with nearbyOriginEntitySelector (" + this.originEntitySelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedCacheType (" + resolvedCacheType + ") that is cached.");
        }
    }

    @Override
    public NearbySelectionConfig inherit(NearbySelectionConfig inheritedConfig) {
        this.originEntitySelectorConfig = ConfigUtils.inheritConfig(this.originEntitySelectorConfig, inheritedConfig.getOriginEntitySelectorConfig());
        this.nearbyDistanceMeterClass = ConfigUtils.inheritOverwritableProperty(this.nearbyDistanceMeterClass, inheritedConfig.getNearbyDistanceMeterClass());
        this.nearbySelectionDistributionType = ConfigUtils.inheritOverwritableProperty(this.nearbySelectionDistributionType, inheritedConfig.getNearbySelectionDistributionType());
        this.blockDistributionSizeMinimum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMinimum, inheritedConfig.getBlockDistributionSizeMinimum());
        this.blockDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMaximum, inheritedConfig.getBlockDistributionSizeMaximum());
        this.blockDistributionSizeRatio = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeRatio, inheritedConfig.getBlockDistributionSizeRatio());
        this.blockDistributionUniformDistributionProbability = ConfigUtils.inheritOverwritableProperty(this.blockDistributionUniformDistributionProbability, inheritedConfig.getBlockDistributionUniformDistributionProbability());
        this.linearDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.linearDistributionSizeMaximum, inheritedConfig.getLinearDistributionSizeMaximum());
        this.parabolicDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.parabolicDistributionSizeMaximum, inheritedConfig.getParabolicDistributionSizeMaximum());
        this.betaDistributionAlpha = ConfigUtils.inheritOverwritableProperty(this.betaDistributionAlpha, inheritedConfig.getBetaDistributionAlpha());
        this.betaDistributionBeta = ConfigUtils.inheritOverwritableProperty(this.betaDistributionBeta, inheritedConfig.getBetaDistributionBeta());
        return this;
    }

    @Override
    public NearbySelectionConfig copyConfig() {
        return new NearbySelectionConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.originEntitySelectorConfig != null) {
            this.originEntitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.nearbyDistanceMeterClass);
    }
}

