/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.optaplanner.core.impl.domain.common.accessor.AbstractMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;

public final class ReflectionMethodMemberAccessor
extends AbstractMemberAccessor {
    private final Class<?> returnType;
    private final String methodName;
    private final Method readMethod;

    public ReflectionMethodMemberAccessor(Method readMethod) {
        this.readMethod = readMethod;
        readMethod.setAccessible(true);
        this.returnType = readMethod.getReturnType();
        this.methodName = readMethod.getName();
        if (readMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("The readMethod (" + readMethod + ") must not have any parameters (" + Arrays.toString(readMethod.getParameterTypes()) + ").");
        }
        if (readMethod.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("The readMethod (" + readMethod + ") must have a return type (" + readMethod.getReturnType() + ").");
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.readMethod.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Class<?> getType() {
        return this.returnType;
    }

    @Override
    public Type getGenericType() {
        return this.readMethod.getGenericReturnType();
    }

    @Override
    public Object executeGetter(Object bean) {
        try {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.methodName + ") getterMethod (" + this.readMethod + ") on bean of class (" + bean.getClass() + ").\n" + MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.methodName + ") getterMethod (" + this.readMethod + ") on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }

    @Override
    public String getSpeedNote() {
        return "slow access with reflection";
    }

    @Override
    public boolean supportSetter() {
        return false;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.readMethod.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.readMethod.getDeclaredAnnotationsByType(annotationClass);
    }

    public String toString() {
        return "method " + this.methodName + " on " + this.readMethod.getDeclaringClass();
    }
}

