/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.constraintweight.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class ConstraintConfigurationDescriptor<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Class<?> constraintConfigurationClass;
    private String constraintPackage;
    private final Map<String, ConstraintWeightDescriptor<Solution_>> constraintWeightDescriptorMap;

    public ConstraintConfigurationDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> constraintConfigurationClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintConfigurationClass = constraintConfigurationClass;
        this.constraintWeightDescriptorMap = new LinkedHashMap<String, ConstraintWeightDescriptor<Solution_>>();
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public Collection<ConstraintWeightDescriptor<Solution_>> getConstraintWeightDescriptors() {
        return this.constraintWeightDescriptorMap.values();
    }

    public ConstraintWeightDescriptor<Solution_> getConstraintWeightDescriptor(String propertyName) {
        return this.constraintWeightDescriptorMap.get(propertyName);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy, ScoreDefinition scoreDefinition) {
        this.processPackAnnotation(descriptorPolicy);
        ArrayList potentiallyOverwritingMethodList = new ArrayList();
        for (Class<?> lineageClass : ConfigUtils.getAllAnnotatedLineageClasses(this.constraintConfigurationClass, ConstraintConfiguration.class)) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            for (Member member2 : memberList) {
                if (member2 instanceof Method && potentiallyOverwritingMethodList.stream().anyMatch(m -> member2.getName().equals(m.getName()) && ReflectionHelper.isMethodOverwritten((Method)member2, m.getDeclaringClass()))) continue;
                this.processParameterAnnotation(descriptorPolicy, member2, scoreDefinition);
            }
            potentiallyOverwritingMethodList.ensureCapacity(potentiallyOverwritingMethodList.size() + memberList.size());
            memberList.stream().filter(member -> member instanceof Method).forEach(member -> potentiallyOverwritingMethodList.add((Method)member));
        }
        if (this.constraintWeightDescriptorMap.isEmpty()) {
            throw new IllegalStateException("The constraintConfigurationClass (" + this.constraintConfigurationClass + ") must have at least 1 member with a " + ConstraintWeight.class.getSimpleName() + " annotation.");
        }
    }

    private void processPackAnnotation(DescriptorPolicy descriptorPolicy) {
        ConstraintConfiguration packAnnotation = this.constraintConfigurationClass.getAnnotation(ConstraintConfiguration.class);
        if (packAnnotation == null) {
            throw new IllegalStateException("The constraintConfigurationClass (" + this.constraintConfigurationClass + ") has been specified as a @" + ConstraintConfigurationProvider.class.getSimpleName() + " in the solution class (" + this.solutionDescriptor.getSolutionClass() + "), but does not have a @" + ConstraintConfiguration.class.getSimpleName() + " annotation.");
        }
        this.constraintPackage = packAnnotation.constraintPackage();
        if (this.constraintPackage.isEmpty()) {
            Package pack = this.constraintConfigurationClass.getPackage();
            this.constraintPackage = pack == null ? "" : pack.getName();
        }
    }

    private void processParameterAnnotation(DescriptorPolicy descriptorPolicy, Member member, ScoreDefinition scoreDefinition) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ConstraintWeight.class)) {
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ConstraintWeight.class, descriptorPolicy.getDomainAccessType());
            if (this.constraintWeightDescriptorMap.containsKey(memberAccessor.getName())) {
                MemberAccessor duplicate = this.constraintWeightDescriptorMap.get(memberAccessor.getName()).getMemberAccessor();
                throw new IllegalStateException("The constraintConfigurationClass (" + this.constraintConfigurationClass + ") has a @" + ConstraintWeight.class.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by a member (" + duplicate + ").\nMaybe the annotation is defined on both the field and its getter.");
            }
            if (!scoreDefinition.getScoreClass().isAssignableFrom(memberAccessor.getType())) {
                throw new IllegalStateException("The constraintConfigurationClass (" + this.constraintConfigurationClass + ") has a @" + ConstraintWeight.class.getSimpleName() + " annotated member (" + memberAccessor + ") with a return type (" + memberAccessor.getType() + ") that is not assignable to the score class (" + scoreDefinition.getScoreClass() + ").\nMaybe make that member (" + memberAccessor.getName() + ") return the score class (" + scoreDefinition.getScoreClass().getSimpleName() + ") instead.");
            }
            ConstraintWeightDescriptor constraintWeightDescriptor = new ConstraintWeightDescriptor(this, memberAccessor);
            this.constraintWeightDescriptorMap.put(memberAccessor.getName(), constraintWeightDescriptor);
        }
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getConstraintConfigurationClass() {
        return this.constraintConfigurationClass;
    }

    public ConstraintWeightDescriptor<Solution_> findConstraintWeightDescriptor(String constraintPackage, String constraintName) {
        return this.constraintWeightDescriptorMap.values().stream().filter(constraintWeightDescriptor -> constraintWeightDescriptor.getConstraintPackage().equals(constraintPackage) && constraintWeightDescriptor.getConstraintName().equals(constraintName)).findFirst().orElse(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.constraintConfigurationClass.getName() + ")";
    }
}

