/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.SubListSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public class SubListSelectorFactory<Solution_> {
    private static final int DEFAULT_MINIMUM_SUB_LIST_SIZE = 1;
    private static final int DEFAULT_MAXIMUM_SUB_LIST_SIZE = Integer.MAX_VALUE;
    private final SubListSelectorConfig config;

    public SubListSelectorFactory(SubListSelectorConfig config) {
        this.config = config;
    }

    public static <Solution_> SubListSelectorFactory<Solution_> create(SubListSelectorConfig subListSelectorConfig) {
        return new SubListSelectorFactory<Solution_>(subListSelectorConfig);
    }

    public RandomSubListSelector<Solution_> buildSubListSelector(HeuristicConfigPolicy<Solution_> configPolicy, ListVariableDescriptor<Solution_> listVariableDescriptor, EntitySelector<Solution_> entitySelector, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        EntityIndependentValueSelector<Solution_> valueSelector = this.buildEntityIndependentValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, inheritedSelectionOrder);
        int minimumSubListSize = Objects.requireNonNullElse(this.config.getMinimumSubListSize(), 1);
        int maximumSubListSize = Objects.requireNonNullElse(this.config.getMaximumSubListSize(), Integer.MAX_VALUE);
        return new RandomSubListSelector<Solution_>(listVariableDescriptor, entitySelector, valueSelector, minimumSubListSize, maximumSubListSize);
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(new ValueSelectorConfig()).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The subListChangeMoveSelector or subListSwapMoveSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        return (EntityIndependentValueSelector)valueSelector;
    }
}

