/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.util.MemoizingSupply;

public final class NearEntityNearbyValueSelector<Solution_>
extends AbstractValueSelector<Solution_> {
    private final ValueSelector<Solution_> childValueSelector;
    private final EntitySelector<Solution_> replayingOriginEntitySelector;
    private final NearbyDistanceMeter<?, ?> nearbyDistanceMeter;
    private final NearbyRandom nearbyRandom;
    private final boolean randomSelection;
    private final boolean discardNearbyIndexZero;
    private final NearbyDistanceMatrixDemand<Solution_, ?, ?> nearbyDistanceMatrixDemand;
    private MemoizingSupply<NearbyDistanceMatrix> nearbyDistanceMatrixSupply = null;

    public NearEntityNearbyValueSelector(ValueSelector<Solution_> childValueSelector, EntitySelector<Solution_> originEntitySelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childValueSelector = childValueSelector;
        if (!(originEntitySelector instanceof MimicReplayingEntitySelector)) {
            throw new IllegalStateException("Impossible state: Nearby value selector (" + this + ") did not receive a replaying entity selector (" + originEntitySelector + ").");
        }
        this.replayingOriginEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The valueSelector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        this.discardNearbyIndexZero = childValueSelector.getVariableDescriptor().getVariablePropertyType().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass());
        this.nearbyDistanceMatrixDemand = new NearbyDistanceMatrixDemand(nearbyDistanceMeter, childValueSelector, this.replayingOriginEntitySelector, this::computeDestinationSize);
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nearbyDistanceMatrixSupply = (MemoizingSupply)solverScope.getScoreDirector().getSupplyManager().demand(this.nearbyDistanceMatrixDemand);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.nearbyDistanceMatrixSupply.read();
    }

    private int computeDestinationSize(Object origin) {
        long childSize = this.childValueSelector.getSize(origin);
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childEntitySelector (" + this.childValueSelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection) {
            int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
            if (this.discardNearbyIndexZero && overallSizeMaximum < Integer.MAX_VALUE) {
                ++overallSizeMaximum;
            }
            if (destinationSize > overallSizeMaximum) {
                destinationSize = overallSizeMaximum;
            }
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.getScoreDirector().getSupplyManager().cancel(this.nearbyDistanceMatrixDemand);
        this.nearbyDistanceMatrixSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity) - (long)(this.discardNearbyIndexZero ? 1 : 0);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        Iterator<Object> replayingOriginEntityIterator = this.replayingOriginEntitySelector.iterator();
        if (!this.randomSelection) {
            return new OriginalEntityNearbyValueIterator(replayingOriginEntityIterator, this.childValueSelector.getSize(entity));
        }
        return new RandomEntityNearbyValueIterator(replayingOriginEntityIterator, this.childValueSelector.getSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NearEntityNearbyValueSelector that = (NearEntityNearbyValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector) && Objects.equals(this.replayingOriginEntitySelector, that.replayingOriginEntitySelector) && Objects.equals(this.nearbyDistanceMeter, that.nearbyDistanceMeter) && Objects.equals(this.nearbyRandom, that.nearbyRandom);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childValueSelector, this.replayingOriginEntitySelector, this.nearbyDistanceMeter, this.nearbyRandom);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.replayingOriginEntitySelector + ", " + this.childValueSelector + ")";
    }

    private final class OriginalEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final long childSize;
        private boolean originSelected = false;
        private boolean originIsNotEmpty;
        private Object origin;
        private int nextNearbyIndex;

        public OriginalEntityNearbyValueIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0;
        }

        private void selectOrigin() {
            if (this.originSelected) {
                return;
            }
            this.originIsNotEmpty = this.replayingOriginEntityIterator.hasNext();
            this.origin = this.replayingOriginEntityIterator.next();
            this.originSelected = true;
        }

        @Override
        public boolean hasNext() {
            this.selectOrigin();
            return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            this.selectOrigin();
            Object next = NearEntityNearbyValueSelector.this.nearbyDistanceMatrixSupply.read().getDestination(this.origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return next;
        }
    }

    private final class RandomEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final int nearbySize;

        public RandomEntityNearbyValueIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - (NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0);
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.replayingOriginEntityIterator.next();
            int nearbyIndex = NearEntityNearbyValueSelector.this.nearbyRandom.nextInt(NearEntityNearbyValueSelector.this.workingRandom, this.nearbySize);
            if (NearEntityNearbyValueSelector.this.discardNearbyIndexZero) {
                ++nearbyIndex;
            }
            return NearEntityNearbyValueSelector.this.nearbyDistanceMatrixSupply.read().getDestination(origin, nearbyIndex);
        }
    }
}

