/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;

@XStreamAlias(value="VrpTimeWindowedCustomer")
public class VrpTimeWindowedCustomer
extends VrpCustomer {
    private int readyTime;
    private int dueTime;
    private int serviceDuration;
    private Integer arrivalTime;

    public int getReadyTime() {
        return this.readyTime;
    }

    public void setReadyTime(int readyTime) {
        this.readyTime = readyTime;
    }

    public int getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(int dueTime) {
        this.dueTime = dueTime;
    }

    public int getServiceDuration() {
        return this.serviceDuration;
    }

    public void setServiceDuration(int serviceDuration) {
        this.serviceDuration = serviceDuration;
    }

    public Integer getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(Integer arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public String getTimeWindowLabel() {
        return this.readyTime + "-" + this.dueTime;
    }

    public Integer getDepartureTime() {
        if (this.arrivalTime == null) {
            return null;
        }
        return Math.max(this.arrivalTime, this.readyTime) + this.serviceDuration;
    }

    public boolean isArrivalBeforeReadyTime() {
        return this.arrivalTime != null && this.arrivalTime < this.readyTime;
    }

    public boolean isArrivalAfterDueTime() {
        return this.arrivalTime != null && this.dueTime < this.arrivalTime;
    }

    @Override
    public VrpTimeWindowedCustomer getNextCustomer() {
        return (VrpTimeWindowedCustomer)super.getNextCustomer();
    }
}

