/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpSchedule;
import org.optaplanner.examples.vehiclerouting.domain.VrpStandstill;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedSchedule;

public class VehicleRoutingIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<VrpSchedule> {
    private boolean timeWindowed;
    private Map<VrpVehicle, Integer> vehicleDemandMap;
    private int hardScore;
    private int softScore;

    @Override
    public void resetWorkingSolution(VrpSchedule schedule) {
        this.timeWindowed = schedule instanceof VrpTimeWindowedSchedule;
        List<VrpVehicle> vehicleList = schedule.getVehicleList();
        this.vehicleDemandMap = new HashMap<VrpVehicle, Integer>(vehicleList.size());
        for (VrpVehicle vehicle : vehicleList) {
            this.vehicleDemandMap.put(vehicle, 0);
        }
        this.hardScore = 0;
        this.softScore = 0;
        for (VrpCustomer customer : schedule.getCustomerList()) {
            this.insertPreviousStandstill(customer);
            this.insertVehicle(customer);
            if (!this.timeWindowed) continue;
            this.insertArrivalTime((VrpTimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        if (entity instanceof VrpVehicle) {
            return;
        }
        this.insertPreviousStandstill((VrpCustomer)entity);
        this.insertVehicle((VrpCustomer)entity);
        if (this.timeWindowed) {
            this.insertArrivalTime((VrpTimeWindowedCustomer)entity);
        }
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        if (entity instanceof VrpVehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.retractPreviousStandstill((VrpCustomer)entity);
        } else if (variableName.equals("vehicle")) {
            this.retractVehicle((VrpCustomer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.retractNextCustomer((VrpCustomer)entity);
        } else if (variableName.equals("arrivalTime")) {
            this.retractArrivalTime((VrpTimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        if (entity instanceof VrpVehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.insertPreviousStandstill((VrpCustomer)entity);
        } else if (variableName.equals("vehicle")) {
            this.insertVehicle((VrpCustomer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.insertNextCustomer((VrpCustomer)entity);
        } else if (variableName.equals("arrivalTime")) {
            this.insertArrivalTime((VrpTimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        if (entity instanceof VrpVehicle) {
            return;
        }
        this.retractPreviousStandstill((VrpCustomer)entity);
        this.retractVehicle((VrpCustomer)entity);
        if (this.timeWindowed) {
            this.retractArrivalTime((VrpTimeWindowedCustomer)entity);
        }
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    private void insertPreviousStandstill(VrpCustomer customer) {
        VrpStandstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore -= customer.getDistanceToPreviousStandstill();
        }
    }

    private void retractPreviousStandstill(VrpCustomer customer) {
        VrpStandstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore += customer.getDistanceToPreviousStandstill();
        }
    }

    private void insertVehicle(VrpCustomer customer) {
        VrpVehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand + customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore -= vehicle.getLocation().getDistance(customer.getLocation());
            }
        }
    }

    private void retractVehicle(VrpCustomer customer) {
        VrpVehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand - customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore += vehicle.getLocation().getDistance(customer.getLocation());
            }
        }
    }

    private void insertNextCustomer(VrpCustomer customer) {
        VrpVehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore -= vehicle.getLocation().getDistance(customer.getLocation());
        }
    }

    private void retractNextCustomer(VrpCustomer customer) {
        VrpVehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore += vehicle.getLocation().getDistance(customer.getLocation());
        }
    }

    private void insertArrivalTime(VrpTimeWindowedCustomer customer) {
        Integer arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null) {
            int readyTime = customer.getReadyTime();
            int dueTime = customer.getDueTime();
            if (dueTime < arrivalTime) {
                this.hardScore -= arrivalTime - dueTime;
            }
            if (arrivalTime < readyTime) {
                this.softScore -= readyTime - arrivalTime;
            }
        }
    }

    private void retractArrivalTime(VrpTimeWindowedCustomer customer) {
        Integer arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null) {
            int readyTime = customer.getReadyTime();
            int dueTime = customer.getDueTime();
            if (dueTime < arrivalTime) {
                this.hardScore += arrivalTime - dueTime;
            }
            if (arrivalTime < readyTime) {
                this.softScore += readyTime - arrivalTime;
            }
        }
    }

    @Override
    public HardSoftScore calculateScore() {
        return HardSoftScore.valueOf(this.hardScore, this.softScore);
    }
}

