/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpSchedule;
import org.optaplanner.examples.vehiclerouting.domain.VrpStandstill;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedSchedule;

public class VehicleRoutingSimpleScoreCalculator
implements SimpleScoreCalculator<VrpSchedule> {
    public HardSoftScore calculateScore(VrpSchedule schedule) {
        boolean timeWindowed = schedule instanceof VrpTimeWindowedSchedule;
        List<VrpCustomer> customerList = schedule.getCustomerList();
        List<VrpVehicle> vehicleList = schedule.getVehicleList();
        HashMap<VrpVehicle, Integer> vehicleDemandMap = new HashMap<VrpVehicle, Integer>(vehicleList.size());
        for (VrpVehicle vehicle : vehicleList) {
            vehicleDemandMap.put(vehicle, 0);
        }
        int hardScore = 0;
        int softScore = 0;
        for (VrpCustomer vrpCustomer : customerList) {
            Integer arrivalTime;
            VrpStandstill previousStandstill = vrpCustomer.getPreviousStandstill();
            if (previousStandstill == null) continue;
            VrpVehicle vehicle = vrpCustomer.getVehicle();
            vehicleDemandMap.put(vehicle, (Integer)vehicleDemandMap.get(vehicle) + vrpCustomer.getDemand());
            softScore -= vrpCustomer.getDistanceToPreviousStandstill();
            if (vrpCustomer.getNextCustomer() == null) {
                softScore -= vehicle.getLocation().getDistance(vrpCustomer.getLocation());
            }
            if (!timeWindowed) continue;
            VrpTimeWindowedCustomer timeWindowedCustomer = (VrpTimeWindowedCustomer)vrpCustomer;
            int readyTime = timeWindowedCustomer.getReadyTime();
            int dueTime = timeWindowedCustomer.getDueTime();
            if (dueTime < (arrivalTime = timeWindowedCustomer.getArrivalTime())) {
                hardScore -= arrivalTime - dueTime;
            }
            if (arrivalTime >= readyTime) continue;
            softScore -= readyTime - arrivalTime;
        }
        for (Map.Entry entry : vehicleDemandMap.entrySet()) {
            int capacity = ((VrpVehicle)entry.getKey()).getCapacity();
            int demand = (Integer)entry.getValue();
            if (demand <= capacity) continue;
            hardScore -= demand - capacity;
        }
        return HardSoftScore.valueOf(hardScore, softScore);
    }
}

