/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic;

import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicSolverPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultConstructionHeuristicSolverPhase
extends AbstractSolverPhase
implements ConstructionHeuristicSolverPhase {
    protected EntityPlacer entityPlacer;
    protected ConstructionHeuristicDecider decider;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;

    public void setEntityPlacer(EntityPlacer entityPlacer) {
        this.entityPlacer = entityPlacer;
    }

    public void setDecider(ConstructionHeuristicDecider decider) {
        this.decider = decider;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        ConstructionHeuristicSolverPhaseScope phaseScope = new ConstructionHeuristicSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        ConstructionHeuristicStepScope stepScope = new ConstructionHeuristicStepScope(phaseScope);
        for (Placement placement : this.entityPlacer) {
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope, placement);
            if (stepScope.getStep() == null) {
                if (this.termination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("    Step index ({}), time spend ({}) terminated without picking a nextStep.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("    No doable selected move at step index ({}), time spend ({}). Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has selected move count (" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + stepScope.getStep() + ").");
            }
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new ConstructionHeuristicStepScope(phaseScope);
            if (!this.termination.isPhaseTerminated(phaseScope)) continue;
            break;
        }
        this.phaseEnded(phaseScope);
    }

    private void doStep(ConstructionHeuristicStepScope stepScope) {
        ConstructionHeuristicSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        Move nextStep = stepScope.getStep();
        nextStep.doMove(stepScope.getScoreDirector());
        phaseScope.getWorkingSolution().setScore(stepScope.getScore());
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), nextStep);
        }
        if (this.assertExpectedStepScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), nextStep);
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entityPlacer.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    public void phaseStarted(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.entityPlacer.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
    }

    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        super.stepStarted(stepScope);
        this.entityPlacer.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        super.stepEnded(stepScope);
        this.entityPlacer.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), selected move count ({}) for constructing step ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    public void phaseEnded(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        Solution newBestSolution = phaseScope.getScoreDirector().cloneWorkingSolution();
        int newBestUninitializedVariableCount = phaseScope.getSolutionDescriptor().countUninitializedVariables(newBestSolution);
        this.bestSolutionRecaller.updateBestSolution(phaseScope.getSolverScope(), newBestSolution, newBestUninitializedVariableCount);
        this.entityPlacer.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entityPlacer.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

