/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.AbstractCachingValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class SortingValueSelector
extends AbstractCachingValueSelector
implements EntityIndependentValueSelector {
    protected final SelectionSorter sorter;

    public SortingValueSelector(EntityIndependentValueSelector childValueSelector, SelectionCacheType cacheType, SelectionSorter sorter) {
        super(childValueSelector, cacheType);
        this.sorter = sorter;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        super.constructCache(solverScope);
        this.sorter.sort(solverScope.getScoreDirector(), this.cachedValueList);
        this.logger.trace("    Sorted cachedValueList with size ({}) in valueSelector({}).", (Object)this.cachedValueList.size(), (Object)this);
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.cachedValueList.iterator();
    }

    public String toString() {
        return "Sorting(" + this.childValueSelector + ")";
    }
}

