/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.coachshuttlegathering.persistence.CoachShuttleGatheringDao;
import org.optaplanner.examples.coachshuttlegathering.persistence.CoachShuttleGatheringExporter;
import org.optaplanner.examples.coachshuttlegathering.persistence.CoachShuttleGatheringImporter;
import org.optaplanner.examples.coachshuttlegathering.swingui.CoachShuttleGatheringPanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class CoachShuttleGatheringApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/coachshuttlegathering/solver/coachShuttleGatheringSolverConfig.xml";

    public static void main(String[] args) {
        CoachShuttleGatheringApp.prepareSwingEnvironment();
        new CoachShuttleGatheringApp().init();
    }

    public CoachShuttleGatheringApp() {
        super("Coach shuttle gathering", "Transport passengers to a hub by using coaches and shuttles.", CoachShuttleGatheringPanel.LOGO_PATH);
    }

    @Override
    protected Solver createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource(SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new CoachShuttleGatheringPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new CoachShuttleGatheringDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new CoachShuttleGatheringImporter();
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new CoachShuttleGatheringExporter();
    }
}

