/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.util.InvestmentNumericUtil;

@XStreamAlias(value="AssetClass")
public class AssetClass
extends AbstractPersistable {
    private String name;
    private Region region;
    private long expectedReturnMillis;
    private long standardDeviationRiskMillis;
    private Map<AssetClass, Long> correlationMillisMap;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public long getExpectedReturnMillis() {
        return this.expectedReturnMillis;
    }

    public void setExpectedReturnMillis(long expectedReturnMillis) {
        this.expectedReturnMillis = expectedReturnMillis;
    }

    public long getStandardDeviationRiskMillis() {
        return this.standardDeviationRiskMillis;
    }

    public void setStandardDeviationRiskMillis(long standardDeviationRiskMillis) {
        this.standardDeviationRiskMillis = standardDeviationRiskMillis;
    }

    public Map<AssetClass, Long> getCorrelationMillisMap() {
        return this.correlationMillisMap;
    }

    public void setCorrelationMillisMap(Map<AssetClass, Long> correlationMillisMap) {
        this.correlationMillisMap = correlationMillisMap;
    }

    public String getExpectedReturnLabel() {
        return InvestmentNumericUtil.formatMillisAsPercentage(this.expectedReturnMillis);
    }

    public String getStandardDeviationRiskLabel() {
        return InvestmentNumericUtil.formatMillisAsPercentage(this.standardDeviationRiskMillis);
    }

    public String getCorrelationLabel(AssetClass other) {
        long correlationMillis = this.correlationMillisMap.get(other);
        return InvestmentNumericUtil.formatMillisAsNumber(correlationMillis);
    }

    @Override
    public String toString() {
        return this.id + "-" + this.name;
    }
}

