/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.persistence;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionImporter;
import org.optaplanner.examples.investment.domain.AssetClass;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentParametrization;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.persistence.InvestmentDao;

public class InvestmentImporter
extends AbstractXlsxSolutionImporter {
    public static void main(String[] args) {
        InvestmentImporter importer = new InvestmentImporter();
        importer.convert("irrinki_1.xlsx", "irrinki_1.xml");
    }

    public InvestmentImporter() {
        super(new InvestmentDao());
    }

    public InvestmentImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public AbstractXlsxSolutionImporter.XslxInputBuilder createXslxInputBuilder() {
        return new InvestmentAllocationInputBuilder();
    }

    public static class InvestmentAllocationInputBuilder
    extends AbstractXlsxSolutionImporter.XslxInputBuilder {
        private InvestmentSolution solution;
        private Map<String, Region> regionMap;

        @Override
        public Solution readSolution() throws IOException {
            this.solution = new InvestmentSolution();
            this.solution.setId(0L);
            this.readParametrization();
            this.readRegionList();
            this.readAssetClassList();
            this.createAssetClassAllocationList();
            this.logger.info("InvestmentAllocation {} has {} asset classes.", (Object)this.getInputId(), (Object)this.solution.getAssetClassList().size());
            return this.solution;
        }

        private void readParametrization() throws IOException {
            XSSFSheet sheet = this.readSheet(0, "Parametrization");
            this.assertCellConstant(sheet.getRow(0).getCell(0), "Investment parametrization");
            InvestmentParametrization parametrization = new InvestmentParametrization();
            parametrization.setId(0L);
            parametrization.setStandardDeviationMillisMaximum(this.parsePercentageMillis(this.readDoubleParameter(sheet.getRow(1), "Standard deviation maximum")));
            this.solution.setParametrization(parametrization);
        }

        private void readRegionList() throws IOException {
            XSSFSheet sheet = this.readSheet(1, "Regions");
            Row headerRow = sheet.getRow(0);
            this.assertCellConstant(headerRow.getCell(0), "Name");
            this.assertCellConstant(headerRow.getCell(1), "Quantity maximum");
            ArrayList<Region> regionList = new ArrayList<Region>();
            this.regionMap = new LinkedHashMap<String, Region>();
            long id = 0L;
            for (Row row : sheet) {
                if (row.getRowNum() < 1) continue;
                Region region = new Region();
                region.setId(id);
                ++id;
                region.setName(this.readStringCell(row.getCell(0)));
                region.setQuantityMillisMaximum(this.parsePercentageMillis(this.readDoubleCell(row.getCell(1))));
                regionList.add(region);
                this.regionMap.put(region.getName(), region);
            }
            this.solution.setRegionList(regionList);
        }

        private void readAssetClassList() throws IOException {
            XSSFSheet sheet = this.readSheet(2, "AssetClasses");
            int ASSET_CLASS_PROPERTIES_COUNT = 5;
            Row groupHeaderRow = sheet.getRow(0);
            this.assertCellConstant(groupHeaderRow.getCell(0), "Asset class");
            this.assertCellConstant(groupHeaderRow.getCell(5), "Correlation");
            Row headerRow = sheet.getRow(1);
            this.assertCellConstant(headerRow.getCell(0), "ID");
            this.assertCellConstant(headerRow.getCell(1), "Name");
            this.assertCellConstant(headerRow.getCell(2), "Region");
            this.assertCellConstant(headerRow.getCell(3), "Expected return");
            this.assertCellConstant(headerRow.getCell(4), "Standard deviation");
            int assetClassListSize = headerRow.getPhysicalNumberOfCells() - 5;
            ArrayList<AssetClass> assetClassList = new ArrayList<AssetClass>(assetClassListSize);
            HashMap<Long, AssetClass> idToAssetClassMap = new HashMap<Long, AssetClass>(assetClassListSize);
            for (int i = 0; i < assetClassListSize; ++i) {
                AssetClass assetClass = new AssetClass();
                assetClass.setId(this.readLongCell(headerRow.getCell(5 + i)));
                assetClassList.add(assetClass);
                AssetClass old = idToAssetClassMap.put(assetClass.getId(), assetClass);
                if (old == null) continue;
                throw new IllegalStateException("The assetClass id (" + assetClass.getId() + ") is not unique.");
            }
            for (Row row : sheet) {
                if (row.getRowNum() < 2) continue;
                if (row.getPhysicalNumberOfCells() != 5 + assetClassListSize) {
                    throw new IllegalArgumentException("The row (" + row.getRowNum() + ") has " + row.getPhysicalNumberOfCells() + " cells, but is expected to have " + (5 + assetClassListSize) + " cells instead.");
                }
                long id = this.readLongCell(row.getCell(0));
                AssetClass assetClass = (AssetClass)idToAssetClassMap.get(id);
                if (assetClass == null) {
                    throw new IllegalStateException("The row (" + row.getRowNum() + ") has an assetClass id (" + id + ") that is not in the header.");
                }
                assetClass.setName(this.readStringCell(row.getCell(1)));
                String regionName = this.readStringCell(row.getCell(2));
                Region region = this.regionMap.get(regionName);
                if (region == null) {
                    throw new IllegalStateException("The row (" + row.getRowNum() + ") has a region (" + regionName + ") that is not in the regions sheet.");
                }
                assetClass.setRegion(region);
                assetClass.setExpectedReturnMillis(this.parsePercentageMillis(this.readDoubleCell(row.getCell(3))));
                assetClass.setStandardDeviationRiskMillis(this.parsePercentageMillis(this.readDoubleCell(row.getCell(4))));
                LinkedHashMap<AssetClass, Long> correlationMillisMap = new LinkedHashMap<AssetClass, Long>(assetClassListSize);
                for (int i = 0; i < assetClassListSize; ++i) {
                    AssetClass other = (AssetClass)assetClassList.get(i);
                    long correlationMillis = this.parsePercentageMillis(this.readDoubleCell(row.getCell(5 + i)));
                    correlationMillisMap.put(other, correlationMillis);
                }
                assetClass.setCorrelationMillisMap(correlationMillisMap);
            }
            this.solution.setAssetClassList(assetClassList);
        }

        private void createAssetClassAllocationList() {
            List<AssetClass> assetClassList = this.solution.getAssetClassList();
            ArrayList<AssetClassAllocation> assetClassAllocationList = new ArrayList<AssetClassAllocation>(assetClassList.size());
            for (AssetClass assetClass : assetClassList) {
                AssetClassAllocation allocation = new AssetClassAllocation();
                allocation.setId(assetClass.getId());
                allocation.setAssetClass(assetClass);
                assetClassAllocationList.add(allocation);
            }
            this.solution.setAssetClassAllocationList(assetClassAllocationList);
        }

        protected long parsePercentageMillis(double numericValue) {
            return (long)(numericValue * 1000.0);
        }

        protected long parsePercentageMillis(String token) {
            BigDecimal millis = token.endsWith("%") ? new BigDecimal(token.substring(0, token.length() - 1)).multiply(new BigDecimal(10L)) : new BigDecimal(token).multiply(new BigDecimal(1000L));
            return millis.longValueExact();
        }
    }
}

