/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.solution.initializer;

import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestmentAllocationSolutionInitializer
implements CustomPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        this.distributeQuantityEvenly(scoreDirector, solution);
    }

    private void distributeQuantityEvenly(ScoreDirector scoreDirector, InvestmentSolution solution) {
        long budget = 1000L;
        int size = solution.getAssetClassAllocationList().size();
        long budgetPerAllocation = budget / (long)size;
        long remainder = budget % (long)size;
        for (AssetClassAllocation allocation : solution.getAssetClassAllocationList()) {
            long quantityMillis = budgetPerAllocation;
            if (remainder > 0L) {
                --remainder;
                ++quantityMillis;
            }
            scoreDirector.beforeVariableChanged(allocation, "quantityMillis");
            allocation.setQuantityMillis(quantityMillis);
            scoreDirector.afterVariableChanged(allocation, "quantityMillis");
        }
    }
}

