/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class ShiftAssignmentSwapMove
extends AbstractMove {
    private ShiftAssignment leftShiftAssignment;
    private ShiftAssignment rightShiftAssignment;

    public ShiftAssignmentSwapMove(ShiftAssignment leftShiftAssignment, ShiftAssignment rightShiftAssignment) {
        this.leftShiftAssignment = leftShiftAssignment;
        this.rightShiftAssignment = rightShiftAssignment;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftShiftAssignment.getEmployee(), (Object)this.rightShiftAssignment.getEmployee());
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new ShiftAssignmentSwapMove(this.rightShiftAssignment, this.leftShiftAssignment);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Employee oldLeftEmployee = this.leftShiftAssignment.getEmployee();
        Employee oldRightEmployee = this.rightShiftAssignment.getEmployee();
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.leftShiftAssignment, oldRightEmployee);
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.rightShiftAssignment, oldLeftEmployee);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftShiftAssignment, this.rightShiftAssignment);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftShiftAssignment.getEmployee(), this.rightShiftAssignment.getEmployee());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ShiftAssignmentSwapMove) {
            ShiftAssignmentSwapMove other = (ShiftAssignmentSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftShiftAssignment, (Object)other.leftShiftAssignment).append((Object)this.rightShiftAssignment, (Object)other.rightShiftAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftShiftAssignment).append((Object)this.rightShiftAssignment).toHashCode();
    }

    public String toString() {
        return this.leftShiftAssignment + " {" + this.leftShiftAssignment.getEmployee() + "} <-> " + this.rightShiftAssignment + " {" + this.rightShiftAssignment.getEmployee() + "}";
    }
}

