/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;

public abstract class VariableDescriptor {
    protected final EntityDescriptor entityDescriptor;
    protected final MemberAccessor variableMemberAccessor;
    protected final String variableName;
    private List<ShadowVariableDescriptor> shadowVariableDescriptorList = new ArrayList<ShadowVariableDescriptor>(4);

    public VariableDescriptor(EntityDescriptor entityDescriptor, MemberAccessor variableMemberAccessor) {
        this.entityDescriptor = entityDescriptor;
        this.variableMemberAccessor = variableMemberAccessor;
        this.variableName = variableMemberAccessor.getName();
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getSimpleEntityAndVariableName() {
        return this.entityDescriptor.getEntityClass().getSimpleName() + "." + this.variableName;
    }

    public Class<?> getVariablePropertyType() {
        return this.variableMemberAccessor.getType();
    }

    public void registerShadowVariableDescriptor(ShadowVariableDescriptor shadowVariableDescriptor) {
        this.shadowVariableDescriptorList.add(shadowVariableDescriptor);
    }

    public List<ShadowVariableDescriptor> getShadowVariableDescriptorList() {
        return this.shadowVariableDescriptorList;
    }

    public boolean isValueNoPotentialAnchor(Object value) {
        return this.entityDescriptor.getEntityClass().isAssignableFrom(value.getClass());
    }

    public Object getValue(Object entity) {
        return this.variableMemberAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variableMemberAccessor.executeSetter(entity, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + " of " + this.entityDescriptor.getEntityClass().getName() + ")";
    }
}

