/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.anchor;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableListener;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class AnchorShadowVariableDescriptor
extends ShadowVariableDescriptor {
    protected VariableDescriptor sourceVariableDescriptor;

    public AnchorShadowVariableDescriptor(EntityDescriptor entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        AnchorShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(AnchorShadowVariable.class);
        String sourceVariableName = shadowVariableAnnotation.sourceVariableName();
        this.sourceVariableDescriptor = this.entityDescriptor.getVariableDescriptor(sourceVariableName);
        if (this.sourceVariableDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + AnchorShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + this.entityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
        }
        if (!(this.sourceVariableDescriptor instanceof GenuineVariableDescriptor) || !((GenuineVariableDescriptor)this.sourceVariableDescriptor).isChained()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + AnchorShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not chained.");
        }
        this.sourceVariableDescriptor.registerShadowVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Demand getProvidedDemand() {
        return new AnchorVariableDemand(this.sourceVariableDescriptor);
    }

    @Override
    public VariableListener buildVariableListener(InnerScoreDirector scoreDirector) {
        SingletonInverseVariableSupply inverseVariableSupply = scoreDirector.getSupplyManager().demand(new SingletonInverseVariableDemand(this.sourceVariableDescriptor));
        return new AnchorVariableListener(this, this.sourceVariableDescriptor, inverseVariableSupply);
    }
}

