/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.List;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;

public abstract class CompositeMoveSelector
extends AbstractMoveSelector {
    protected final List<MoveSelector> childMoveSelectorList;
    protected final boolean randomSelection;

    protected CompositeMoveSelector(List<MoveSelector> childMoveSelectorList, boolean randomSelection) {
        this.childMoveSelectorList = childMoveSelectorList;
        this.randomSelection = randomSelection;
        for (MoveSelector childMoveSelector : childMoveSelectorList) {
            this.phaseLifecycleSupport.addEventListener(childMoveSelector);
        }
        if (!randomSelection && !childMoveSelectorList.isEmpty()) {
            for (MoveSelector childMoveSelector : childMoveSelectorList.subList(0, childMoveSelectorList.size() - 1)) {
                if (!childMoveSelector.isNeverEnding()) continue;
                throw new IllegalStateException("The selector (" + this + ")'s non-last childMoveSelector (" + childMoveSelector + ") has neverEnding (" + childMoveSelector.isNeverEnding() + ") with randomSelection (" + randomSelection + ")." + (childMoveSelector.isCountable() ? "" : "\nThe selector is not countable, check the " + ValueRange.class.getSimpleName() + "s involved."));
            }
        }
    }

    public List<MoveSelector> getChildMoveSelectorList() {
        return this.childMoveSelectorList;
    }

    @Override
    public boolean isCountable() {
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            if (moveSelector.isCountable()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.childMoveSelectorList + ")";
    }
}

