/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedSwapMove
extends SwapMove {
    public ChainedSwapMove(Collection<GenuineVariableDescriptor> variableDescriptors, Object leftEntity, Object rightEntity) {
        super(variableDescriptors, leftEntity, rightEntity);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new ChainedSwapMove(this.variableDescriptors, this.rightEntity, this.leftEntity);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            if (!variableDescriptor.isChained()) {
                scoreDirector.beforeVariableChanged(variableDescriptor, this.leftEntity);
                variableDescriptor.setValue(this.leftEntity, oldRightValue);
                scoreDirector.afterVariableChanged(variableDescriptor, this.leftEntity);
                scoreDirector.beforeVariableChanged(variableDescriptor, this.rightEntity);
                variableDescriptor.setValue(this.rightEntity, oldLeftValue);
                scoreDirector.afterVariableChanged(variableDescriptor, this.rightEntity);
                continue;
            }
            if (oldRightValue != this.leftEntity) {
                ChainedMoveUtils.doChainedChange(scoreDirector, this.leftEntity, variableDescriptor, oldRightValue);
            }
            if (oldLeftValue == this.rightEntity) continue;
            ChainedMoveUtils.doChainedChange(scoreDirector, this.rightEntity, variableDescriptor, oldLeftValue);
        }
    }
}

