/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingSwapMove
extends AbstractMove {
    private final GenuineVariableDescriptor variableDescriptor;
    private final SubChain leftSubChain;
    private final SubChain rightSubChain;

    public SubChainReversingSwapMove(GenuineVariableDescriptor variableDescriptor, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Object leftEntity : this.leftSubChain.getEntityList()) {
            if (!this.rightSubChain.getEntityList().contains(leftEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SubChainReversingSwapMove(this.variableDescriptor, this.rightSubChain.reverse(), this.leftSubChain.reverse());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        ChainedMoveUtils.doReverseSubChainChange(scoreDirector, this.leftSubChain, this.variableDescriptor, oldRightValue == this.leftSubChain.getLastEntity() ? oldLeftValue : oldRightValue);
        ChainedMoveUtils.doReverseSubChainChange(scoreDirector, this.rightSubChain, this.variableDescriptor, oldLeftValue == this.rightSubChain.getLastEntity() ? this.leftSubChain.getFirstEntity() : oldLeftValue);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftSubChain.getSize() + this.rightSubChain.getSize());
        entities.addAll(this.leftSubChain.getEntityList());
        entities.addAll(this.rightSubChain.getEntityList());
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingSwapMove) {
            SubChainReversingSwapMove other = (SubChainReversingSwapMove)o;
            return new EqualsBuilder().append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append((Object)this.leftSubChain, (Object)other.leftSubChain).append((Object)this.rightSubChain, (Object)other.rightSubChain).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.variableDescriptor).append((Object)this.leftSubChain).append((Object)this.rightSubChain).toHashCode();
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + oldLeftValue + "} <-reversing-> " + this.rightSubChain.toDottedString() + " {" + oldRightValue + "}";
    }
}

