/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class TailChainSwapMove
extends AbstractMove {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final AnchorVariableSupply anchorVariableSupply;
    protected final Object leftEntity;
    protected final Object rightValue;

    public TailChainSwapMove(GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, AnchorVariableSupply anchorVariableSupply, Object leftEntity, Object rightValue) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.anchorVariableSupply = anchorVariableSupply;
        this.leftEntity = leftEntity;
        this.rightValue = rightValue;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightValue() {
        return this.rightValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (ObjectUtils.equals((Object)leftValue, (Object)this.rightValue) || ObjectUtils.equals((Object)this.leftEntity, (Object)this.rightValue) || ObjectUtils.equals((Object)rightEntity, (Object)leftValue)) {
            return false;
        }
        if (rightEntity == null) {
            Object rightAnchor;
            Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
            Object object = rightAnchor = !this.variableDescriptor.isValueNoPotentialAnchor(this.rightValue) ? this.rightValue : this.anchorVariableSupply.getAnchor(this.rightValue);
            if (leftAnchor == rightAnchor) {
                return false;
            }
        }
        if (!this.variableDescriptor.isValueRangeEntityIndependent()) {
            ValueRange<?> rightValueRange;
            ValueRangeDescriptor valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            Solution workingSolution = scoreDirector.getWorkingSolution();
            if (rightEntity != null && !(rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution, rightEntity)).contains(leftValue)) {
                return false;
            }
            ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (!leftValueRange.contains(this.rightValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        Object rightAnchor = !this.variableDescriptor.isValueNoPotentialAnchor(this.rightValue) ? this.rightValue : this.anchorVariableSupply.getAnchor(this.rightValue);
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        if (leftAnchor != rightAnchor) {
            return new TailChainSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.anchorVariableSupply, this.leftEntity, leftValue);
        }
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (rightEntity != null) {
            return new TailChainSwapMove(this.variableDescriptor, this.inverseVariableSupply, this.anchorVariableSupply, rightEntity, this.rightValue);
        }
        throw new IllegalStateException("Impossible state, because isMoveDoable() should not return true.");
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        Object rightAnchor = !this.variableDescriptor.isValueNoPotentialAnchor(this.rightValue) ? this.rightValue : this.anchorVariableSupply.getAnchor(this.rightValue);
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        if (leftAnchor != rightAnchor) {
            scoreDirector.beforeVariableChanged(this.variableDescriptor, this.leftEntity);
            if (rightEntity != null) {
                scoreDirector.beforeVariableChanged(this.variableDescriptor, rightEntity);
            }
            this.variableDescriptor.setValue(this.leftEntity, this.rightValue);
            if (rightEntity != null) {
                this.variableDescriptor.setValue(rightEntity, leftValue);
            }
            scoreDirector.afterVariableChanged(this.variableDescriptor, this.leftEntity);
            if (rightEntity != null) {
                scoreDirector.afterVariableChanged(this.variableDescriptor, rightEntity);
            }
        } else {
            boolean rightValueIsLater = this.isRightValueLaterThanLeftEntity(leftAnchor);
            if (!rightValueIsLater) {
                Object leftNextEntity = this.inverseVariableSupply.getInverseSingleton(this.leftEntity);
                scoreDirector.beforeVariableChanged(this.variableDescriptor, this.leftEntity);
                this.variableDescriptor.setValue(this.leftEntity, this.rightValue);
                if (leftNextEntity != null) {
                    scoreDirector.beforeVariableChanged(this.variableDescriptor, leftNextEntity);
                }
                Object entity = leftValue;
                Object previousEntity = this.leftEntity;
                while (previousEntity != rightEntity) {
                    Object value = this.variableDescriptor.getValue(entity);
                    scoreDirector.changeVariableFacade(this.variableDescriptor, entity, previousEntity);
                    previousEntity = entity;
                    entity = value;
                }
                scoreDirector.afterVariableChanged(this.variableDescriptor, this.leftEntity);
                if (leftNextEntity != null) {
                    this.variableDescriptor.setValue(leftNextEntity, previousEntity);
                    scoreDirector.afterVariableChanged(this.variableDescriptor, leftNextEntity);
                }
            } else {
                Object value;
                Object next;
                Object leftNextEntity = this.inverseVariableSupply.getInverseSingleton(this.leftEntity);
                scoreDirector.beforeVariableChanged(this.variableDescriptor, this.inverseVariableSupply.getInverseSingleton(leftAnchor));
                Object lastEntity = this.rightValue;
                while ((next = this.inverseVariableSupply.getInverseSingleton(lastEntity)) != null) {
                    lastEntity = next;
                }
                Object entity = lastEntity;
                Object previousEntity = leftAnchor;
                while (entity != this.rightValue) {
                    value = this.variableDescriptor.getValue(entity);
                    scoreDirector.changeVariableFacade(this.variableDescriptor, entity, previousEntity);
                    previousEntity = entity;
                    entity = value;
                }
                if (leftNextEntity != null) {
                    scoreDirector.changeVariableFacade(this.variableDescriptor, leftNextEntity, previousEntity);
                }
                entity = this.leftEntity;
                previousEntity = this.rightValue;
                while (entity != leftAnchor) {
                    value = this.variableDescriptor.getValue(entity);
                    if (value == leftAnchor) {
                        this.variableDescriptor.setValue(entity, previousEntity);
                        scoreDirector.afterVariableChanged(this.variableDescriptor, entity);
                    } else {
                        scoreDirector.changeVariableFacade(this.variableDescriptor, entity, previousEntity);
                    }
                    previousEntity = entity;
                    entity = value;
                }
            }
        }
    }

    protected boolean isRightValueLaterThanLeftEntity(Object anchor) {
        Object value = this.rightValue;
        while (value != anchor) {
            if (value == this.leftEntity) {
                return true;
            }
            value = this.variableDescriptor.getValue(value);
        }
        return false;
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        return Arrays.asList(this.leftEntity, rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        return Arrays.asList(leftValue, this.rightValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TailChainSwapMove) {
            TailChainSwapMove other = (TailChainSwapMove)o;
            return new EqualsBuilder().append(this.leftEntity, other.leftEntity).append(this.rightValue, other.rightValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftEntity).append(this.rightValue).toHashCode();
    }

    public String toString() {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object rightEntity = this.inverseVariableSupply.getInverseSingleton(this.rightValue);
        return this.leftEntity + " {" + leftValue + "} <-tailChainSwap-> " + rightEntity + " {" + this.rightValue + "}";
    }
}

