/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.swingui.CloudComputerPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;

public class CloudBalancingPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/cloudbalancing/swingui/cloudBalancingLogo.png";
    private final ImageIcon cloudComputerIcon = new ImageIcon(this.getClass().getResource("cloudComputer.png"));
    private final ImageIcon addCloudComputerIcon = new ImageIcon(this.getClass().getResource("addCloudComputer.png"));
    private final ImageIcon deleteCloudComputerIcon = new ImageIcon(this.getClass().getResource("deleteCloudComputer.png"));
    private final ImageIcon cloudProcessIcon = new ImageIcon(this.getClass().getResource("cloudProcess.png"));
    private final ImageIcon addCloudProcessIcon = new ImageIcon(this.getClass().getResource("addCloudProcess.png"));
    private final ImageIcon deleteCloudProcessIcon = new ImageIcon(this.getClass().getResource("deleteCloudProcess.png"));
    private JPanel computersPanel;
    private CloudComputerPanel unassignedPanel;
    private Map<CloudComputer, CloudComputerPanel> computerToPanelMap;
    private int maximumComputerCpuPower;
    private int maximumComputerMemory;
    private int maximumComputerNetworkBandwidth;

    public CloudBalancingPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JPanel headerPanel = this.createHeaderPanel();
        JPanel computersPanel = this.createComputersPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(computersPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(computersPanel, -2, -2, -2));
    }

    public ImageIcon getCloudComputerIcon() {
        return this.cloudComputerIcon;
    }

    public ImageIcon getAddCloudComputerIcon() {
        return this.addCloudComputerIcon;
    }

    public ImageIcon getDeleteCloudComputerIcon() {
        return this.deleteCloudComputerIcon;
    }

    public ImageIcon getCloudProcessIcon() {
        return this.cloudProcessIcon;
    }

    public ImageIcon getAddCloudProcessIcon() {
        return this.addCloudProcessIcon;
    }

    public ImageIcon getDeleteCloudProcessIcon() {
        return this.deleteCloudProcessIcon;
    }

    public int getMaximumComputerCpuPower() {
        return this.maximumComputerCpuPower;
    }

    public int getMaximumComputerMemory() {
        return this.maximumComputerMemory;
    }

    public int getMaximumComputerNetworkBandwidth() {
        return this.maximumComputerNetworkBandwidth;
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridLayout(0, 5));
        JPanel addPanel = new JPanel(new GridLayout());
        JButton addComputerButton = new JButton(this.addCloudComputerIcon);
        addComputerButton.setToolTipText("Add computer");
        addComputerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudComputer computer = new CloudComputer();
                computer.setCpuPower(12);
                computer.setMemory(32);
                computer.setNetworkBandwidth(12);
                computer.setCost(1400);
                CloudBalancingPanel.this.addComputer(computer);
            }
        });
        addComputerButton.setMargin(new Insets(0, 0, 0, 0));
        addPanel.add(addComputerButton);
        JButton addProcessButton = new JButton(this.addCloudProcessIcon);
        addProcessButton.setToolTipText("Add process");
        addProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudProcess process = new CloudProcess();
                process.setRequiredCpuPower(3);
                process.setRequiredMemory(8);
                process.setRequiredNetworkBandwidth(3);
                CloudBalancingPanel.this.addProcess(process);
            }
        });
        addProcessButton.setMargin(new Insets(0, 0, 0, 0));
        addPanel.add(addProcessButton);
        JPanel cornerPanel = new JPanel(new BorderLayout());
        cornerPanel.add((Component)addPanel, "East");
        headerPanel.add(cornerPanel);
        JLabel cpuPowerLabel = new JLabel("CPU power");
        headerPanel.add(cpuPowerLabel);
        JLabel memoryLabel = new JLabel("Memory");
        headerPanel.add(memoryLabel);
        JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
        headerPanel.add(networkBandwidthLabel);
        JLabel costLabel = new JLabel("Cost");
        headerPanel.add(costLabel);
        return headerPanel;
    }

    private JPanel createComputersPanel() {
        this.computersPanel = new JPanel(new GridLayout(0, 1));
        this.computerToPanelMap = new LinkedHashMap<CloudComputer, CloudComputerPanel>();
        return this.computersPanel;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private CloudBalance getCloudBalance() {
        return (CloudBalance)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        CloudBalance cloudBalance = (CloudBalance)solution;
        this.maximumComputerCpuPower = 0;
        this.maximumComputerMemory = 0;
        this.maximumComputerNetworkBandwidth = 0;
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            if (computer.getCpuPower() > this.maximumComputerCpuPower) {
                this.maximumComputerCpuPower = computer.getCpuPower();
            }
            if (computer.getMemory() > this.maximumComputerMemory) {
                this.maximumComputerMemory = computer.getMemory();
            }
            if (computer.getNetworkBandwidth() <= this.maximumComputerNetworkBandwidth) continue;
            this.maximumComputerNetworkBandwidth = computer.getNetworkBandwidth();
        }
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            if (computerPanel.getComputer() == null) continue;
            this.computersPanel.remove(computerPanel);
        }
        this.computerToPanelMap.clear();
        this.computersPanel.removeAll();
        this.unassignedPanel = new CloudComputerPanel(this, null);
        this.computersPanel.add(this.unassignedPanel);
        this.computerToPanelMap.put(null, this.unassignedPanel);
        this.updatePanel(solution);
    }

    @Override
    public void updatePanel(Solution solution) {
        CloudBalance cloudBalance = (CloudBalance)solution;
        LinkedHashSet<CloudComputer> deadCloudComputerSet = new LinkedHashSet<CloudComputer>(this.computerToPanelMap.keySet());
        deadCloudComputerSet.remove(null);
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            deadCloudComputerSet.remove(computer);
            CloudComputerPanel computerPanel = this.computerToPanelMap.get(computer);
            if (computerPanel == null) {
                computerPanel = new CloudComputerPanel(this, computer);
                this.computersPanel.add(computerPanel);
                this.computerToPanelMap.put(computer, computerPanel);
            }
            computerPanel.clearProcesses();
        }
        this.unassignedPanel.clearProcesses();
        for (CloudProcess process : cloudBalance.getProcessList()) {
            CloudComputer computer = process.getComputer();
            CloudComputerPanel computerPanel = this.computerToPanelMap.get(computer);
            computerPanel.addProcess(process);
        }
        for (CloudComputer deadComputer : deadCloudComputerSet) {
            CloudComputerPanel deadComputerPanel = this.computerToPanelMap.remove(deadComputer);
            this.computersPanel.remove(deadComputerPanel);
        }
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            computerPanel.update();
        }
        this.computersPanel.validate();
    }

    public void addComputer(final CloudComputer computer) {
        this.logger.info("Scheduling addition of computer ({}).", (Object)computer);
        this.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
                long nextComputerId = 0L;
                for (CloudComputer otherComputer : cloudBalance.getComputerList()) {
                    if (nextComputerId > otherComputer.getId()) continue;
                    nextComputerId = otherComputer.getId() + 1L;
                }
                computer.setId(nextComputerId);
                cloudBalance.setComputerList(new ArrayList<CloudComputer>(cloudBalance.getComputerList()));
                scoreDirector.beforeProblemFactAdded((Object)computer);
                cloudBalance.getComputerList().add(computer);
                scoreDirector.afterProblemFactAdded((Object)computer);
            }
        });
    }

    public void deleteComputer(final CloudComputer computer) {
        this.logger.info("Scheduling delete of computer ({}).", (Object)computer);
        this.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
                for (CloudProcess process : cloudBalance.getProcessList()) {
                    if (!ObjectUtils.equals((Object)process.getComputer(), (Object)computer)) continue;
                    scoreDirector.beforeVariableChanged((Object)process, "computer");
                    process.setComputer(null);
                    scoreDirector.afterVariableChanged((Object)process, "computer");
                }
                cloudBalance.setComputerList(new ArrayList<CloudComputer>(cloudBalance.getComputerList()));
                Iterator<CloudComputer> it = cloudBalance.getComputerList().iterator();
                while (it.hasNext()) {
                    CloudComputer workingComputer = it.next();
                    if (!ObjectUtils.equals((Object)workingComputer, (Object)computer)) continue;
                    scoreDirector.beforeProblemFactRemoved((Object)workingComputer);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved((Object)workingComputer);
                    break;
                }
            }
        });
    }

    public void addProcess(final CloudProcess process) {
        this.logger.info("Scheduling addition of process ({}).", (Object)process);
        this.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
                long nextProcessId = 0L;
                for (CloudProcess otherProcess : cloudBalance.getProcessList()) {
                    if (nextProcessId > otherProcess.getId()) continue;
                    nextProcessId = otherProcess.getId() + 1L;
                }
                process.setId(nextProcessId);
                scoreDirector.beforeEntityAdded((Object)process);
                cloudBalance.getProcessList().add(process);
                scoreDirector.afterEntityAdded((Object)process);
            }
        });
    }

    public void deleteProcess(final CloudProcess process) {
        this.logger.info("Scheduling delete of process ({}).", (Object)process);
        this.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
                Iterator<CloudProcess> it = cloudBalance.getProcessList().iterator();
                while (it.hasNext()) {
                    CloudProcess workingProcess = it.next();
                    if (!ObjectUtils.equals((Object)workingProcess, (Object)process)) continue;
                    scoreDirector.beforeEntityRemoved((Object)workingProcess);
                    it.remove();
                    scoreDirector.afterEntityRemoved((Object)workingProcess);
                    break;
                }
            }
        });
    }

    public JButton createButton(CloudProcess process) {
        JButton button = new JButton(new CloudProcessAction(process));
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private class CloudProcessAction
    extends AbstractAction {
        private CloudProcess process;

        public CloudProcessAction(CloudProcess process) {
            super(process.getLabel());
            this.process = process;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(1, 2));
            listFieldsPanel.add(new JLabel("Computer:"));
            List<CloudComputer> computerList = CloudBalancingPanel.this.getCloudBalance().getComputerList();
            JComboBox<Object> computerListField = new JComboBox<Object>(computerList.toArray(new Object[computerList.size() + 1]));
            computerListField.setRenderer(new LabeledComboBoxRenderer());
            computerListField.setSelectedItem(this.process.getComputer());
            listFieldsPanel.add(computerListField);
            int result = JOptionPane.showConfirmDialog(CloudBalancingPanel.this.getRootPane(), listFieldsPanel, "Select computer", 2);
            if (result == 0) {
                CloudComputer toComputer = (CloudComputer)computerListField.getSelectedItem();
                if (this.process.getComputer() != toComputer) {
                    CloudBalancingPanel.this.solutionBusiness.doChangeMove(this.process, "computer", toComputer);
                }
                CloudBalancingPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

