/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain.solver;

import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;

public class TransportTimeToHubUpdatingVariableListener
implements VariableListener<BusOrStop> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, BusOrStop busOrStop) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, BusOrStop busOrStop) {
        if (busOrStop instanceof BusStop) {
            this.updateTransportTimeToHub(scoreDirector, (BusStop)busOrStop);
        } else if (busOrStop instanceof Shuttle) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, (Shuttle)busOrStop);
        }
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, BusOrStop busOrStop) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, BusOrStop busOrStop) {
        if (busOrStop instanceof BusStop) {
            this.updateTransportTimeToHub(scoreDirector, (BusStop)busOrStop);
        } else if (busOrStop instanceof Shuttle) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, (Shuttle)busOrStop);
        }
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, BusOrStop busOrStop) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, BusOrStop busOrStop) {
    }

    protected void updateTransportTimeToHub(ScoreDirector scoreDirector, BusStop sourceStop) {
        Object transportTimeToHub;
        Bus bus = sourceStop.getBus();
        if (bus == null) {
            transportTimeToHub = null;
        } else {
            StopOrHub next = sourceStop.getNextStop();
            transportTimeToHub = next == null ? ((next = bus.getDestination()) instanceof BusStop && ((BusStop)next).getBus() instanceof Shuttle ? null : (next == null ? null : next.getTransportTimeToHub())) : next.getTransportTimeToHub();
            if (transportTimeToHub != null) {
                transportTimeToHub = (Integer)transportTimeToHub + bus.getDurationFromTo(sourceStop.getLocation(), next.getLocation());
            }
        }
        this.updateTransportTime(scoreDirector, sourceStop, bus, (Integer)transportTimeToHub);
    }

    private void updateTransportTime(ScoreDirector scoreDirector, BusStop sourceStop, Bus bus, Integer transportTimeToHub) {
        if (ObjectUtils.equals((Object)sourceStop.getTransportTimeToHub(), (Object)transportTimeToHub)) {
            return;
        }
        scoreDirector.beforeVariableChanged((Object)sourceStop, "transportTimeToHub");
        sourceStop.setTransportTimeToHub(transportTimeToHub);
        scoreDirector.afterVariableChanged((Object)sourceStop, "transportTimeToHub");
        this.updateTransportTimeForTransferShuttleList(scoreDirector, sourceStop, bus);
        BusStop toStop = sourceStop;
        BusOrStop busOrStop = sourceStop.getPreviousBusOrStop();
        while (busOrStop instanceof BusStop) {
            BusStop stop = (BusStop)busOrStop;
            if (transportTimeToHub != null) {
                transportTimeToHub = transportTimeToHub + bus.getDurationFromTo(stop.getLocation(), toStop.getLocation());
            }
            scoreDirector.beforeVariableChanged((Object)stop, "transportTimeToHub");
            stop.setTransportTimeToHub(transportTimeToHub);
            scoreDirector.afterVariableChanged((Object)stop, "transportTimeToHub");
            this.updateTransportTimeForTransferShuttleList(scoreDirector, stop, bus);
            toStop = stop;
            busOrStop = stop.getPreviousBusOrStop();
        }
    }

    private void updateTransportTimeForTransferShuttleList(ScoreDirector scoreDirector, BusStop parentStop, Bus parentBus) {
        List<Shuttle> transferShuttleList = parentStop.getTransferShuttleList();
        if (transferShuttleList.isEmpty()) {
            return;
        }
        Integer parentTransportTimeToHub = parentStop.getTransportTimeToHub();
        if (parentBus instanceof Shuttle) {
            parentTransportTimeToHub = null;
        }
        for (Shuttle shuttle : transferShuttleList) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, parentStop, parentTransportTimeToHub, shuttle);
        }
    }

    private void updateTransportTimeToHubOfShuttle(ScoreDirector scoreDirector, Shuttle shuttle) {
        StopOrHub destination = shuttle.getDestination();
        Object destinationTransportTimeToHub = destination != null ? (destination instanceof BusStop && ((BusStop)destination).getBus() instanceof Shuttle ? null : (destination == null ? null : destination.getTransportTimeToHub())) : null;
        this.updateTransportTimeToHubOfShuttle(scoreDirector, destination, (Integer)destinationTransportTimeToHub, shuttle);
    }

    private void updateTransportTimeToHubOfShuttle(ScoreDirector scoreDirector, StopOrHub parentStop, Integer parentTransportTimeToHub, Shuttle shuttle) {
        BusStop lastStop = null;
        for (BusStop stop = shuttle.getNextStop(); stop != null; stop = stop.getNextStop()) {
            lastStop = stop;
        }
        if (lastStop == null) {
            return;
        }
        Integer transportTimeToHub = parentTransportTimeToHub;
        if (transportTimeToHub != null) {
            transportTimeToHub = transportTimeToHub + shuttle.getDurationFromTo(lastStop.getLocation(), parentStop.getLocation());
        }
        this.updateTransportTime(scoreDirector, lastStop, shuttle, transportTimeToHub);
    }
}

