/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingSolutionPainter {
    private static final int TEXT_SIZE = 12;
    private static final int TIME_WINDOW_DIAMETER = 26;
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    private static final String IMAGE_PATH_PREFIX = "/org/optaplanner/examples/vehiclerouting/swingui/";
    private ImageIcon depotImageIcon = new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/depot.png"));
    private ImageIcon[] vehicleImageIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChameleon.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleButter.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleSkyBlue.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChocolate.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehiclePlum.png"))};
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public VehicleRoutingSolutionPainter() {
        if (this.vehicleImageIcons.length != TangoColorFactory.SEQUENCE_1.length) {
            throw new IllegalStateException("The vehicleImageIcons length (" + this.vehicleImageIcons.length + ") should be equal to the TangoColorFactory.SEQUENCE length (" + TangoColorFactory.SEQUENCE_1.length + ").");
        }
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    public LatitudeLongitudeTranslator getTranslator() {
        return this.translator;
    }

    public void reset(VehicleRoutingSolution solution, Dimension size, ImageObserver imageObserver) {
        this.translator = new LatitudeLongitudeTranslator();
        for (Location location : solution.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        long maximumTimeWindowTime = this.determineMaximumTimeWindowTime(solution);
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height - 10.0 - 12.0);
        Graphics2D g = this.createCanvas(width, height);
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setStroke(TangoColorFactory.NORMAL_STROKE);
        for (Customer customer : solution.getCustomerList()) {
            Location location = customer.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.setColor(TangoColorFactory.ALUMINIUM_4);
            g.fillRect(x - 1, y - 1, 3, 3);
            String demandString = Integer.toString(customer.getDemand());
            g.drawString(demandString, x - g.getFontMetrics().stringWidth(demandString) / 2, y - 6);
            if (!(customer instanceof TimeWindowedCustomer)) continue;
            TimeWindowedCustomer timeWindowedCustomer = (TimeWindowedCustomer)customer;
            g.setColor(TangoColorFactory.ALUMINIUM_3);
            int circleX = x - 13;
            int circleY = y + 5;
            g.drawOval(circleX, circleY, 26, 26);
            g.fillArc(circleX, circleY, 26, 26, 90 - this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getReadyTime()), this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getReadyTime()) - this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getDueTime()));
            if (timeWindowedCustomer.getArrivalTime() == null) continue;
            if (timeWindowedCustomer.isArrivalAfterDueTime()) {
                g.setColor(TangoColorFactory.SCARLET_2);
            } else if (timeWindowedCustomer.isArrivalBeforeReadyTime()) {
                g.setColor(TangoColorFactory.ORANGE_2);
            } else {
                g.setColor(TangoColorFactory.ALUMINIUM_6);
            }
            g.setStroke(TangoColorFactory.THICK_STROKE);
            int circleCenterY = y + 5 + 13;
            int angle = this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getArrivalTime());
            g.drawLine(x, circleCenterY, x + (int)(Math.sin(Math.toRadians(angle)) * 16.0), circleCenterY - (int)(Math.cos(Math.toRadians(angle)) * 16.0));
            g.setStroke(TangoColorFactory.NORMAL_STROKE);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        for (Depot depot : solution.getDepotList()) {
            int x = this.translator.translateLongitudeToX(depot.getLocation().getLongitude());
            int y = this.translator.translateLatitudeToY(depot.getLocation().getLatitude());
            g.fillRect(x - 2, y - 2, 5, 5);
            g.drawImage(this.depotImageIcon.getImage(), x - this.depotImageIcon.getIconWidth() / 2, y - 2 - this.depotImageIcon.getIconHeight(), imageObserver);
        }
        int colorIndex = 0;
        for (Vehicle vehicle : solution.getVehicleList()) {
            g.setColor(TangoColorFactory.SEQUENCE_2[colorIndex]);
            Customer vehicleInfoCustomer = null;
            long longestNonDepotDistance = -1L;
            int load = 0;
            for (Customer customer : solution.getCustomerList()) {
                if (customer.getPreviousStandstill() == null || customer.getVehicle() != vehicle) continue;
                load += customer.getDemand();
                Location previousLocation = customer.getPreviousStandstill().getLocation();
                Location location = customer.getLocation();
                this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), location instanceof AirLocation, false);
                long distance = customer.getDistanceFromPreviousStandstill();
                if (customer.getPreviousStandstill() instanceof Customer) {
                    if (longestNonDepotDistance < distance) {
                        longestNonDepotDistance = distance;
                        vehicleInfoCustomer = customer;
                    }
                } else if (vehicleInfoCustomer == null) {
                    vehicleInfoCustomer = customer;
                }
                if (customer.getNextCustomer() != null) continue;
                Location vehicleLocation = vehicle.getLocation();
                this.translator.drawRoute(g, location.getLongitude(), location.getLatitude(), vehicleLocation.getLongitude(), vehicleLocation.getLatitude(), location instanceof AirLocation, true);
            }
            if (vehicleInfoCustomer != null) {
                if (load > vehicle.getCapacity()) {
                    g.setColor(TangoColorFactory.SCARLET_2);
                }
                Location previousLocation = vehicleInfoCustomer.getPreviousStandstill().getLocation();
                Location location = vehicleInfoCustomer.getLocation();
                double longitude = (previousLocation.getLongitude() + location.getLongitude()) / 2.0;
                int x = this.translator.translateLongitudeToX(longitude);
                double latitude = (previousLocation.getLatitude() + location.getLatitude()) / 2.0;
                int y = this.translator.translateLatitudeToY(latitude);
                boolean ascending = previousLocation.getLongitude() < location.getLongitude() ^ previousLocation.getLatitude() < location.getLatitude();
                ImageIcon vehicleImageIcon = this.vehicleImageIcons[colorIndex];
                int vehicleInfoHeight = vehicleImageIcon.getIconHeight() + 2 + 12;
                g.drawImage(vehicleImageIcon.getImage(), x + 1, ascending ? y - vehicleInfoHeight - 1 : y + 1, imageObserver);
                g.drawString(load + " / " + vehicle.getCapacity(), x + 1, ascending ? y - 1 : y + vehicleInfoHeight + 1);
            }
            colorIndex = (colorIndex + 1) % TangoColorFactory.SEQUENCE_2.length;
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        g.fillRect(5, (int)height - 12 - 12 - 6, 5, 5);
        g.drawString("Depot", 15, (int)height - 10 - 12);
        String vehiclesSizeString = solution.getVehicleList().size() + " vehicles";
        g.drawString(vehiclesSizeString, ((int)width - g.getFontMetrics().stringWidth(vehiclesSizeString)) / 2, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(6, (int)height - 6 - 6, 3, 3);
        g.drawString(solution instanceof TimeWindowedVehicleRoutingSolution ? "Customer: demand, time window and arrival time" : "Customer: demand", 15, (int)height - 5);
        String customersSizeString = solution.getCustomerList().size() + " customers";
        g.drawString(customersSizeString, ((int)width - g.getFontMetrics().stringWidth(customersSizeString)) / 2, (int)height - 5);
        if (solution.getDistanceType() == DistanceType.AIR_DISTANCE) {
            String clickString = "Right click anywhere on the map to add a customer.";
            g.drawString(clickString, (int)width - 5 - g.getFontMetrics().stringWidth(clickString), (int)height - 5);
        }
        g.setColor(TangoColorFactory.ORANGE_3);
        HardSoftLongScore score = solution.getScore();
        if (score != null) {
            String distanceString = !score.isFeasible() ? "Not feasible" : solution.getDistanceString(NUMBER_FORMAT);
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(distanceString, (int)width - g.getFontMetrics().stringWidth(distanceString) - 10, (int)height - 10 - 12);
        }
    }

    private long determineMaximumTimeWindowTime(VehicleRoutingSolution solution) {
        long timeWindowTime;
        long maximumTimeWindowTime = 0L;
        for (Depot depot : solution.getDepotList()) {
            if (!(depot instanceof TimeWindowedDepot) || (timeWindowTime = ((TimeWindowedDepot)depot).getDueTime()) <= maximumTimeWindowTime) continue;
            maximumTimeWindowTime = timeWindowTime;
        }
        for (Customer customer : solution.getCustomerList()) {
            if (!(customer instanceof TimeWindowedCustomer) || (timeWindowTime = ((TimeWindowedCustomer)customer).getDueTime()) <= maximumTimeWindowTime) continue;
            maximumTimeWindowTime = timeWindowTime;
        }
        return maximumTimeWindowTime;
    }

    private int calculateTimeWindowDegree(long maximumTimeWindowTime, long timeWindowTime) {
        return (int)(360L * timeWindowTime / maximumTimeWindowTime);
    }

    public Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }
}

