/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.PhreakActivationIterator;
import org.drools.core.common.TerminalNodeIterator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.util.Iterator;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class ActivationIterator
implements Iterator {
    private InternalWorkingMemory wm;
    private Iterator nodeIter;
    private TerminalNode node;
    private Iterator<LeftTuple> leftTupleIter;
    private LeftTuple currentLeftTuple;

    ActivationIterator() {
    }

    private ActivationIterator(InternalWorkingMemory wm, KieBase kbase) {
        this.wm = wm;
        this.nodeIter = TerminalNodeIterator.iterator(kbase);
        while (this.currentLeftTuple == null && (this.node = (TerminalNode)this.nodeIter.next()) != null) {
            if (!(this.node instanceof RuleTerminalNode)) continue;
            this.leftTupleIter = LeftTupleIterator.iterator(wm, this.node);
            this.currentLeftTuple = this.leftTupleIter.next();
        }
    }

    public static Iterator iterator(InternalWorkingMemory wm) {
        if (wm.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            return PhreakActivationIterator.iterator(wm);
        }
        return new ActivationIterator(wm, (KieBase)wm.getKnowledgeBase());
    }

    public static Iterator iterator(KieSession ksession) {
        return ActivationIterator.iterator((InternalWorkingMemoryEntryPoint)ksession);
    }

    public static Iterator iterator(InternalWorkingMemoryEntryPoint ksession) {
        InternalWorkingMemory wm = ksession.getInternalWorkingMemory();
        if (wm.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            return PhreakActivationIterator.iterator(wm);
        }
        return new ActivationIterator(ksession.getInternalWorkingMemory(), ((KieSession)ksession).getKieBase());
    }

    public Object next() {
        Activation acc = null;
        if (this.currentLeftTuple != null) {
            Object obj = this.currentLeftTuple.getObject();
            acc = obj == Boolean.TRUE ? null : (Activation)obj;
            this.currentLeftTuple = this.leftTupleIter.next();
            while (this.currentLeftTuple == null && (this.node = (TerminalNode)this.nodeIter.next()) != null) {
                if (!(this.node instanceof RuleTerminalNode)) continue;
                this.leftTupleIter = LeftTupleIterator.iterator(this.wm, this.node);
                this.currentLeftTuple = this.leftTupleIter.next();
            }
        }
        return acc;
    }
}

