/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LeftTupleRBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.LeftTupleList;

public class LeftTupleIndexRBTree
implements LeftTupleMemory,
Externalizable {
    private LeftTupleRBTree<Comparable<Comparable>> tree;
    private AbstractHashTable.FieldIndex index;
    private IndexUtil.ConstraintType constraintType;
    private int size;

    public LeftTupleIndexRBTree() {
    }

    public LeftTupleIndexRBTree(IndexUtil.ConstraintType constraintType, AbstractHashTable.FieldIndex index) {
        this.index = index;
        this.constraintType = constraintType;
        this.tree = new LeftTupleRBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.index);
        out.writeObject((Object)this.constraintType);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (LeftTupleRBTree)in.readObject();
        this.index = (AbstractHashTable.FieldIndex)in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
    }

    @Override
    public void add(LeftTuple tuple) {
        Comparable key = this.getIndexedValue(tuple);
        LeftTupleRBTree.Node<Comparable<Comparable>> list = this.tree.insert(key);
        list.add(tuple);
        ++this.size;
    }

    @Override
    public void remove(LeftTuple tuple) {
        LeftTupleList list = tuple.getMemory();
        list.remove(tuple);
        if (list.getFirst() == null) {
            this.tree.delete((Comparable<Comparable>)((LeftTupleRBTree.Node)list).key);
        }
        --this.size;
    }

    @Override
    public void removeAdd(LeftTuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<LeftTuple> result = new ArrayList<LeftTuple>();
        LeftTupleList list = null;
        while ((list = (LeftTupleList)it.next(list)) != null) {
            for (LeftTuple entry = list.getFirst(); entry != null; entry = (LeftTuple)entry.getNext()) {
                result.add(entry);
            }
        }
        return result.toArray(new LeftTuple[result.size()]);
    }

    @Override
    public LeftTuple getFirst(RightTuple rightTuple) {
        Comparable key = this.getIndexedValue(rightTuple);
        return this.getNext(key, true);
    }

    @Override
    public Iterator iterator() {
        LeftTupleRBTree.Node<Comparable<Comparable>> list = this.tree.first();
        LeftTuple firstTuple = list != null ? list.first : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(LeftTuple leftTuple) {
        Comparable key = this.getIndexedValue(leftTuple);
        return this.tree.lookup(key) != null;
    }

    @Override
    public FastIterator fastIterator() {
        return new LeftTupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator() {
        return new LeftTupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator(LeftTuple leftTuple) {
        FastIterator fastIterator = this.fullFastIterator();
        Comparable key = this.getIndexedValue(leftTuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    private Comparable getIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.index.getDeclaration().getExtractor().getValue(leftTuple.get(this.index.getDeclaration()).getObject());
    }

    private Comparable getIndexedValue(RightTuple rightTuple) {
        return (Comparable)this.index.getExtractor().getValue(rightTuple.getFactHandle().getObject());
    }

    private LeftTuple getNext(Comparable key, boolean first) {
        LeftTupleRBTree.Node<Comparable<Comparable>> firstNode;
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, LeftTupleRBTree.Boundary.LOWER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, LeftTupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, LeftTupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, LeftTupleRBTree.Boundary.UPPER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.constraintType));
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    @Override
    public void clear() {
        this.tree = new LeftTupleRBTree();
    }

    public class LeftTupleFastIterator
    implements FastIterator {
        @Override
        public Entry next(Entry object) {
            if (object == null) {
                LeftTupleRBTree.Node firstNode = LeftTupleIndexRBTree.this.tree.first();
                return firstNode == null ? null : firstNode.getFirst();
            }
            LeftTuple leftTuple = (LeftTuple)object;
            LeftTuple next = (LeftTuple)leftTuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = LeftTupleIndexRBTree.this.getIndexedValue(leftTuple);
            return LeftTupleIndexRBTree.this.getNext(key, false);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

