/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.solver.CloudComputerStrengthComparator;
import org.optaplanner.examples.cloudbalancing.domain.solver.CloudProcessDifficultyComparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@PlanningEntity(difficultyComparatorClass=CloudProcessDifficultyComparator.class)
@XStreamAlias(value="CloudProcess")
public class CloudProcess
extends AbstractPersistable {
    private int requiredCpuPower;
    private int requiredMemory;
    private int requiredNetworkBandwidth;
    private CloudComputer computer;

    public int getRequiredCpuPower() {
        return this.requiredCpuPower;
    }

    public void setRequiredCpuPower(int requiredCpuPower) {
        this.requiredCpuPower = requiredCpuPower;
    }

    public int getRequiredMemory() {
        return this.requiredMemory;
    }

    public void setRequiredMemory(int requiredMemory) {
        this.requiredMemory = requiredMemory;
    }

    public int getRequiredNetworkBandwidth() {
        return this.requiredNetworkBandwidth;
    }

    public void setRequiredNetworkBandwidth(int requiredNetworkBandwidth) {
        this.requiredNetworkBandwidth = requiredNetworkBandwidth;
    }

    @PlanningVariable(valueRangeProviderRefs={"computerRange"}, strengthComparatorClass=CloudComputerStrengthComparator.class)
    public CloudComputer getComputer() {
        return this.computer;
    }

    public void setComputer(CloudComputer computer) {
        this.computer = computer;
    }

    public int getRequiredMultiplicand() {
        return this.requiredCpuPower * this.requiredMemory * this.requiredNetworkBandwidth;
    }

    public String getLabel() {
        return "Process " + this.id;
    }
}

