/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

public class CloudProcessSwapMove
extends AbstractMove {
    private CloudProcess leftCloudProcess;
    private CloudProcess rightCloudProcess;

    public CloudProcessSwapMove(CloudProcess leftCloudProcess, CloudProcess rightCloudProcess) {
        this.leftCloudProcess = leftCloudProcess;
        this.rightCloudProcess = rightCloudProcess;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftCloudProcess.getComputer(), (Object)this.rightCloudProcess.getComputer());
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new CloudProcessSwapMove(this.rightCloudProcess, this.leftCloudProcess);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        CloudComputer oldLeftCloudComputer = this.leftCloudProcess.getComputer();
        CloudComputer oldRightCloudComputer = this.rightCloudProcess.getComputer();
        CloudBalancingMoveHelper.moveCloudComputer(scoreDirector, this.leftCloudProcess, oldRightCloudComputer);
        CloudBalancingMoveHelper.moveCloudComputer(scoreDirector, this.rightCloudProcess, oldLeftCloudComputer);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftCloudProcess, this.rightCloudProcess);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftCloudProcess.getComputer(), this.rightCloudProcess.getComputer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudProcessSwapMove) {
            CloudProcessSwapMove other = (CloudProcessSwapMove)((Object)o);
            return new EqualsBuilder().append((Object)this.leftCloudProcess, (Object)other.leftCloudProcess).append((Object)this.rightCloudProcess, (Object)other.rightCloudProcess).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftCloudProcess).append((Object)this.rightCloudProcess).toHashCode();
    }

    public String toString() {
        return this.leftCloudProcess + " {" + this.leftCloudProcess.getComputer() + "} <-> " + this.rightCloudProcess + " {" + this.rightCloudProcess.getComputer() + "}";
    }
}

