/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractPngSolutionImporter
extends AbstractSolutionImporter {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "png";

    protected AbstractPngSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    protected AbstractPngSolutionImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract PngInputBuilder createPngInputBuilder();

    @Override
    public Solution readSolution(File inputFile) {
        Solution solution;
        InputStream in = null;
        try {
            BufferedImage image = ImageIO.read(inputFile);
            PngInputBuilder pngInputBuilder = this.createPngInputBuilder();
            pngInputBuilder.setInputFile(inputFile);
            pngInputBuilder.setImage(image);
            try {
                solution = pngInputBuilder.readSolution();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Exception in inputFile (" + inputFile + ")", e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        this.logger.info("Imported: {}", (Object)inputFile);
        return solution;
    }

    public static abstract class PngInputBuilder
    extends AbstractSolutionImporter.InputBuilder {
        protected File inputFile;
        protected BufferedImage image;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public abstract Solution readSolution() throws IOException;

        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getPath());
        }
    }
}

