/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.score;

import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.Sector;

public class InvestmentEasyScoreCalculator
implements EasyScoreCalculator<InvestmentSolution> {
    public HardSoftLongScore calculateScore(InvestmentSolution solution) {
        long hardScore = 0L;
        long softScore = 0L;
        long squaredFemtosMaximum = solution.getParametrization().calculateSquaredStandardDeviationFemtosMaximum();
        long squaredFemtos = solution.calculateStandardDeviationSquaredFemtos();
        if (squaredFemtos > squaredFemtosMaximum) {
            hardScore -= squaredFemtos - squaredFemtosMaximum;
        }
        Map<Region, Long> regionQuantityTotalMap = solution.calculateRegionQuantityMillisTotalMap();
        for (Region region : solution.getRegionList()) {
            long available = region.getQuantityMillisMaximum() - regionQuantityTotalMap.get(region);
            if (available >= 0L) continue;
            hardScore += available;
        }
        Map<Sector, Long> sectorQuantityTotalMap = solution.calculateSectorQuantityMillisTotalMap();
        for (Sector sector : solution.getSectorList()) {
            long available = sector.getQuantityMillisMaximum() - sectorQuantityTotalMap.get(sector);
            if (available >= 0L) continue;
            hardScore += available;
        }
        return HardSoftLongScore.valueOf((long)hardScore, (long)(softScore += solution.calculateExpectedReturnMicros()));
    }
}

