/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

public enum DayOfWeek {
    MONDAY("Monday"),
    TUESDAY("Tuesday"),
    WEDNESDAY("Wednesday"),
    THURSDAY("Thursday"),
    FRIDAY("Friday"),
    SATURDAY("Saturday"),
    SUNDAY("Sunday");

    private String code;

    public static DayOfWeek valueOfCalendar(int calendarDayInWeek) {
        switch (calendarDayInWeek) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        throw new IllegalArgumentException("The calendarDayInWeek (" + calendarDayInWeek + ") is not supported.");
    }

    public static DayOfWeek valueOfCode(String code) {
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            if (!code.equalsIgnoreCase(dayOfWeek.getCode())) continue;
            return dayOfWeek;
        }
        return null;
    }

    private DayOfWeek(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public int getDistanceToNext(DayOfWeek other) {
        int distance = other.ordinal() - this.ordinal();
        if (distance < 0) {
            distance += 7;
        }
        return distance;
    }

    public DayOfWeek determineNextDayOfWeek() {
        switch (this) {
            case MONDAY: {
                return TUESDAY;
            }
            case TUESDAY: {
                return WEDNESDAY;
            }
            case WEDNESDAY: {
                return THURSDAY;
            }
            case THURSDAY: {
                return FRIDAY;
            }
            case FRIDAY: {
                return SATURDAY;
            }
            case SATURDAY: {
                return SUNDAY;
            }
            case SUNDAY: {
                return MONDAY;
            }
        }
        throw new IllegalArgumentException("The dayOfWeek (" + (Object)((Object)this) + ") is not supported.");
    }

    public String getLabel() {
        return this.code.substring(0, 2);
    }

    public String toString() {
        return this.code.substring(0, 3);
    }
}

