/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.solver.DepotAngleCustomerDifficultyWeightFactory;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleCustomerDifficultyWeightFactory.class)
@XStreamAlias(value="VrpCustomer")
@XStreamInclude(value={TimeWindowedCustomer.class})
public class Customer
extends AbstractPersistable
implements Standstill {
    protected Location location;
    protected int demand;
    protected Standstill previousStandstill;
    protected Customer nextCustomer;
    protected Vehicle vehicle;

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    @PlanningVariable(valueRangeProviderRefs={"vehicleRange", "customerRange"}, graphType=PlanningVariableGraphType.CHAINED)
    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    @Override
    public Customer getNextCustomer() {
        return this.nextCustomer;
    }

    @Override
    public void setNextCustomer(Customer nextCustomer) {
        this.nextCustomer = nextCustomer;
    }

    @Override
    @AnchorShadowVariable(sourceVariableName="previousStandstill")
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public long getDistanceFromPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0L;
        }
        return this.getDistanceFrom(this.previousStandstill);
    }

    public long getDistanceFrom(Standstill standstill) {
        return standstill.getLocation().getDistanceTo(this.location);
    }

    public long getDistanceTo(Standstill standstill) {
        return this.location.getDistanceTo(standstill.getLocation());
    }

    @Override
    public String toString() {
        if (this.location.getName() == null) {
            return super.toString();
        }
        return this.location.getName();
    }
}

