/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XpathAnalysis
implements Iterable<XpathPart> {
    private final List<XpathPart> parts;

    public XpathAnalysis(List<XpathPart> parts) {
        this.parts = parts;
    }

    @Override
    public Iterator<XpathPart> iterator() {
        return this.parts.iterator();
    }

    public static XpathAnalysis analyze(String xpath) {
        if (xpath.charAt(0) != '/') {
            return null;
        }
        boolean iterate = true;
        ArrayList<XpathPart> parts = new ArrayList<XpathPart>();
        ArrayList<String> constraints = new ArrayList<String>();
        String inlineCast = null;
        int index = -1;
        int lastStart = 1;
        int nestedParam = 0;
        int nestedCurly = 0;
        int nestedSquare = 0;
        boolean isQuoted = false;
        String field = null;
        block13: for (int i = 1; i < xpath.length(); ++i) {
            switch (xpath.charAt(i)) {
                case '.': 
                case '/': {
                    if (isQuoted || nestedParam != 0 || nestedCurly != 0 || nestedSquare != 0) continue block13;
                    if (field == null) {
                        field = xpath.substring(lastStart, i).trim();
                    }
                    parts.add(new XpathPart(field, iterate, constraints, inlineCast, index));
                    iterate = xpath.charAt(i) == '/';
                    constraints = new ArrayList();
                    inlineCast = null;
                    index = -1;
                    lastStart = i + 1;
                    field = null;
                    continue block13;
                }
                case '(': {
                    if (isQuoted) continue block13;
                    ++nestedParam;
                    continue block13;
                }
                case ')': {
                    if (isQuoted || --nestedParam >= 0) continue block13;
                    return null;
                }
                case '[': {
                    if (isQuoted || nestedParam != 0 || nestedCurly != 0) continue block13;
                    if (nestedSquare == 0) {
                        if (field == null) {
                            field = xpath.substring(lastStart, i).trim();
                        }
                        lastStart = i + 1;
                    }
                    ++nestedSquare;
                    continue block13;
                }
                case ']': {
                    if (isQuoted || nestedParam != 0 || nestedCurly != 0) continue block13;
                    if (--nestedSquare == 0) {
                        try {
                            index = Integer.parseInt(xpath.substring(lastStart, i).trim());
                            continue block13;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                    if (nestedSquare >= 0) continue block13;
                    return null;
                }
                case '{': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 0) continue block13;
                    if (nestedCurly == 0) {
                        if (field == null) {
                            field = xpath.substring(lastStart, i).trim();
                        }
                        lastStart = i + 1;
                    }
                    ++nestedCurly;
                    continue block13;
                }
                case '}': {
                    String constraint;
                    if (isQuoted || nestedParam != 0 || nestedSquare != 0) continue block13;
                    if (--nestedCurly == 0) {
                        constraint = xpath.substring(lastStart, i).trim();
                        if (constraint.startsWith("#")) {
                            inlineCast = constraint.substring(1);
                            continue block13;
                        }
                        constraints.add(constraint);
                        continue block13;
                    }
                    if (nestedCurly >= 0) continue block13;
                    return null;
                }
                case ',': {
                    if (isQuoted || nestedParam != 0 || nestedCurly != 1) continue block13;
                    String constraint = xpath.substring(lastStart, i).trim();
                    if (constraint.startsWith("#")) {
                        inlineCast = constraint.substring(1);
                    } else {
                        constraints.add(constraint);
                    }
                    lastStart = i + 1;
                    continue block13;
                }
                case '\"': 
                case '\'': {
                    isQuoted = !isQuoted;
                }
            }
        }
        if (field == null) {
            field = xpath.substring(lastStart).trim();
        }
        parts.add(new XpathPart(field, iterate, constraints, inlineCast, index));
        return new XpathAnalysis(parts);
    }

    public static class XpathPart {
        private final String field;
        private final boolean iterate;
        private final List<String> constraints;
        private final String inlineCast;
        private final int index;

        public XpathPart(String field, boolean iterate, List<String> constraints, String inlineCast, int index) {
            this.field = field;
            this.iterate = iterate;
            this.constraints = constraints;
            this.inlineCast = inlineCast;
            this.index = index;
        }

        public String getField() {
            return this.field;
        }

        public boolean isIterate() {
            return this.iterate;
        }

        public List<String> getConstraints() {
            return this.constraints;
        }

        public String getInlineCast() {
            return this.inlineCast;
        }

        public int getIndex() {
            return this.index;
        }

        public void addInlineCastConstraint(Class<?> clazz) {
            this.constraints.add(0, "this instanceof " + clazz.getCanonicalName());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.field);
            if (this.index >= 0) {
                sb.append("[").append(this.index).append("]");
            }
            if (!this.constraints.isEmpty()) {
                sb.append("{");
                sb.append(this.constraints.get(0));
                for (int i = 1; i < this.constraints.size(); ++i) {
                    sb.append(", ").append(this.constraints.get(i));
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }
}

