/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicForagerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import org.optaplanner.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import org.optaplanner.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="constructionHeuristic")
public class ConstructionHeuristicPhaseConfig
extends PhaseConfig {
    protected ConstructionHeuristicType constructionHeuristicType = null;
    protected EntitySorterManner entitySorterManner = null;
    protected ValueSorterManner valueSorterManner = null;
    @XStreamImplicit
    protected List<EntityPlacerConfig> entityPlacerConfigList = null;
    @XStreamAlias(value="forager")
    protected ConstructionHeuristicForagerConfig foragerConfig = null;

    public ConstructionHeuristicType getConstructionHeuristicType() {
        return this.constructionHeuristicType;
    }

    public void setConstructionHeuristicType(ConstructionHeuristicType constructionHeuristicType) {
        this.constructionHeuristicType = constructionHeuristicType;
    }

    public EntitySorterManner getEntitySorterManner() {
        return this.entitySorterManner;
    }

    public void setEntitySorterManner(EntitySorterManner entitySorterManner) {
        this.entitySorterManner = entitySorterManner;
    }

    public ValueSorterManner getValueSorterManner() {
        return this.valueSorterManner;
    }

    public void setValueSorterManner(ValueSorterManner valueSorterManner) {
        this.valueSorterManner = valueSorterManner;
    }

    public EntityPlacerConfig getEntityPlacerConfig() {
        return this.entityPlacerConfigList == null ? null : this.entityPlacerConfigList.get(0);
    }

    public void setEntityPlacerConfig(EntityPlacerConfig entityPlacerConfig) {
        this.entityPlacerConfigList = entityPlacerConfig == null ? null : Collections.singletonList(entityPlacerConfig);
    }

    public ConstructionHeuristicForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ConstructionHeuristicForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    @Override
    public ConstructionHeuristicPhase buildPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        EntityPlacerConfig entityPlacerConfig;
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        phaseConfigPolicy.setReinitializeVariableFilterEnabled(true);
        phaseConfigPolicy.setInitializedChainedValueFilterEnabled(true);
        DefaultConstructionHeuristicPhase phase = new DefaultConstructionHeuristicPhase();
        this.configurePhase(phase, phaseIndex, phaseConfigPolicy, bestSolutionRecaller, solverTermination);
        phase.setDecider(this.buildDecider(phaseConfigPolicy, phase.getTermination()));
        ConstructionHeuristicType constructionHeuristicType_ = (ConstructionHeuristicType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.constructionHeuristicType), (Object)((Object)ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE)));
        phaseConfigPolicy.setEntitySorterManner(this.entitySorterManner != null ? this.entitySorterManner : constructionHeuristicType_.getDefaultEntitySorterManner());
        phaseConfigPolicy.setValueSorterManner(this.valueSorterManner != null ? this.valueSorterManner : constructionHeuristicType_.getDefaultValueSorterManner());
        if (ConfigUtils.isEmptyCollection(this.entityPlacerConfigList)) {
            entityPlacerConfig = constructionHeuristicType_.newEntityPlacerConfig();
        } else if (this.entityPlacerConfigList.size() == 1) {
            entityPlacerConfig = this.entityPlacerConfigList.get(0);
            if (this.constructionHeuristicType != null) {
                throw new IllegalArgumentException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") must not be configured if the entityPlacerConfig (" + entityPlacerConfig + ") is explicitly configured.");
            }
        } else {
            throw new IllegalArgumentException("The entityPlacerConfigList (" + this.entityPlacerConfigList + ") must be a singleton or empty. Use multiple " + ConstructionHeuristicPhaseConfig.class + " elements to initialize multiple entity classes.");
        }
        EntityPlacer entityPlacer = entityPlacerConfig.buildEntityPlacer(phaseConfigPolicy, phase.getTermination());
        phase.setEntityPlacer(entityPlacer);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedStepScore(true);
        }
        return phase;
    }

    private ConstructionHeuristicDecider buildDecider(HeuristicConfigPolicy configPolicy, Termination termination) {
        ConstructionHeuristicForagerConfig foragerConfig_ = this.foragerConfig == null ? new ConstructionHeuristicForagerConfig() : this.foragerConfig;
        ConstructionHeuristicForager forager = foragerConfig_.buildForager(configPolicy);
        ConstructionHeuristicDecider decider = new ConstructionHeuristicDecider(termination, forager);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    public void inherit(ConstructionHeuristicPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.constructionHeuristicType = ConfigUtils.inheritOverwritableProperty(this.constructionHeuristicType, inheritedConfig.getConstructionHeuristicType());
        this.entitySorterManner = ConfigUtils.inheritOverwritableProperty(this.entitySorterManner, inheritedConfig.getEntitySorterManner());
        this.valueSorterManner = ConfigUtils.inheritOverwritableProperty(this.valueSorterManner, inheritedConfig.getValueSorterManner());
        this.setEntityPlacerConfig(ConfigUtils.inheritOverwritableProperty(this.getEntityPlacerConfig(), inheritedConfig.getEntityPlacerConfig()));
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }
}

