/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.domain;

import com.google.common.base.Predicate;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

@XStreamAlias(value="scanAnnotatedClasses")
public class ScanAnnotatedClassesConfig {
    @XStreamImplicit(itemFieldName="packageInclude")
    private List<String> packageIncludeList = null;

    public List<String> getPackageIncludeList() {
        return this.packageIncludeList;
    }

    public void setPackageIncludeList(List<String> packageIncludeList) {
        this.packageIncludeList = packageIncludeList;
    }

    public SolutionDescriptor buildSolutionDescriptor() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (!ConfigUtils.isEmptyCollection(this.packageIncludeList)) {
            FilterBuilder filterBuilder = new FilterBuilder();
            for (String packageInclude : this.packageIncludeList) {
                builder.addUrls(ClasspathHelper.forPackage((String)packageInclude, (ClassLoader[])null));
                filterBuilder.includePackage(new String[]{packageInclude});
            }
            builder.filterInputsBy((Predicate)filterBuilder);
        } else {
            builder.addUrls(ClasspathHelper.forPackage((String)"", (ClassLoader[])new ClassLoader[0]));
        }
        Reflections reflections = new Reflections((Configuration)builder);
        Class<? extends Solution> solutionClass = this.loadSolutionClass(reflections);
        List<Class<?>> entityClassList = this.loadEntityClassList(reflections);
        return SolutionDescriptor.buildSolutionDescriptor(solutionClass, entityClassList);
    }

    protected Class<? extends Solution> loadSolutionClass(Reflections reflections) {
        Set solutionClassSet = reflections.getTypesAnnotatedWith(PlanningSolution.class);
        this.retainOnlyClassesWithDeclaredAnnotation(solutionClassSet, PlanningSolution.class);
        if (ConfigUtils.isEmptyCollection(solutionClassSet)) {
            throw new IllegalStateException("The scanAnnotatedClasses (" + this + ") did not find any classes with a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (solutionClassSet.size() > 1) {
            throw new IllegalStateException("The scanAnnotatedClasses (" + this + ") found multiple classes (" + solutionClassSet + ") with a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        Class solutionClass = (Class)solutionClassSet.iterator().next();
        return solutionClass;
    }

    protected List<Class<?>> loadEntityClassList(Reflections reflections) {
        Set entityClassSet = reflections.getTypesAnnotatedWith(PlanningEntity.class);
        this.retainOnlyClassesWithDeclaredAnnotation(entityClassSet, PlanningEntity.class);
        if (ConfigUtils.isEmptyCollection(entityClassSet)) {
            throw new IllegalStateException("The scanAnnotatedClasses (" + this + ") did not find any classes with a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        return new ArrayList(entityClassSet);
    }

    private void retainOnlyClassesWithDeclaredAnnotation(Set<Class<?>> classSet, Class<? extends Annotation> annotation) {
        Iterator<Class<?>> it = classSet.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            if (clazz.isAnnotationPresent(annotation)) continue;
            it.remove();
        }
    }

    public void inherit(ScanAnnotatedClassesConfig inheritedConfig) {
        this.packageIncludeList = ConfigUtils.inheritMergeableListProperty(this.packageIncludeList, inheritedConfig.getPackageIncludeList());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.packageIncludeList == null ? "" : this.packageIncludeList) + ")";
    }
}

