/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.AlphabeticMemberComparator;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.FieldMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MethodMemberAccessor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.custom.CustomShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class EntityDescriptor {
    public static final List<Class<? extends Annotation>> VARIABLE_ANNOTATION_CLASSES = Arrays.asList(PlanningVariable.class, InverseRelationShadowVariable.class, AnchorShadowVariable.class, CustomShadowVariable.class);
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> entityClass;
    private SelectionFilter movableEntitySelectionFilter;
    private SelectionSorter decreasingDifficultySorter;
    private List<EntityDescriptor> inheritedEntityDescriptorList;
    private Map<String, GenuineVariableDescriptor> declaredGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor> declaredShadowVariableDescriptorMap;
    private Map<String, GenuineVariableDescriptor> effectiveGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor> effectiveShadowVariableDescriptorMap;
    private Map<String, VariableDescriptor> effectiveVariableDescriptorMap;

    public EntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> entityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations(descriptorPolicy);
        this.processValueRangeProviderAnnotations(descriptorPolicy);
        this.processPlanningVariableAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has been specified as a planning entity in the configuration," + " but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(descriptorPolicy, entityAnnotation);
        this.processDifficulty(descriptorPolicy, entityAnnotation);
    }

    private void processMovable(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.decreasingDifficultySorter = new ComparatorSelectionSorter(difficultyComparator, SelectionSorterOrder.DESCENDING);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.decreasingDifficultySorter = new WeightFactorySelectionSorter(difficultyWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processValueRangeProviderAnnotations(DescriptorPolicy descriptorPolicy) {
        List<Field> fieldList = Arrays.asList(this.entityClass.getDeclaredFields());
        Collections.sort(fieldList, new AlphabeticMemberComparator());
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(ValueRangeProvider.class)) continue;
            FieldMemberAccessor memberAccessor = new FieldMemberAccessor(field);
            descriptorPolicy.addFromEntityValueRangeProvider(memberAccessor);
        }
        List<Method> methodList = Arrays.asList(this.entityClass.getDeclaredMethods());
        Collections.sort(methodList, new AlphabeticMemberComparator());
        for (Method method : methodList) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            ReflectionHelper.assertReadMethod(method, ValueRangeProvider.class);
            MethodMemberAccessor memberAccessor = new MethodMemberAccessor(method);
            descriptorPolicy.addFromEntityValueRangeProvider(memberAccessor);
        }
    }

    private void processPlanningVariableAnnotations(DescriptorPolicy descriptorPolicy) {
        this.declaredGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor>();
        this.declaredShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor>();
        boolean noVariableAnnotation = true;
        List<Field> fieldList = Arrays.asList(this.entityClass.getDeclaredFields());
        Collections.sort(fieldList, new AlphabeticMemberComparator());
        for (Field field : fieldList) {
            Class<? extends Annotation> variableAnnotationClass = this.extractVariableAnnotationClass(field);
            if (variableAnnotationClass == null) continue;
            noVariableAnnotation = false;
            FieldMemberAccessor memberAccessor = new FieldMemberAccessor(field);
            this.registerVariableAccessor(descriptorPolicy, variableAnnotationClass, memberAccessor);
        }
        List<Method> methodList = Arrays.asList(this.entityClass.getDeclaredMethods());
        Collections.sort(methodList, new AlphabeticMemberComparator());
        for (Method method : methodList) {
            Class<? extends Annotation> variableAnnotationClass = this.extractVariableAnnotationClass(method);
            if (variableAnnotationClass == null) continue;
            noVariableAnnotation = false;
            ReflectionHelper.assertGetterMethod(method, variableAnnotationClass);
            BeanPropertyMemberAccessor memberAccessor = new BeanPropertyMemberAccessor(method);
            if (!memberAccessor.supportSetter()) {
                throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + variableAnnotationClass.getSimpleName() + " annotated getter method (" + method + "), but lacks a setter for that property (" + memberAccessor.getName() + ").");
            }
            this.registerVariableAccessor(descriptorPolicy, variableAnnotationClass, memberAccessor);
        }
        if (noVariableAnnotation) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") should have at least 1 getter method or 1 field with a " + PlanningVariable.class.getSimpleName() + " annotation or a shadow variable annotation.");
        }
    }

    private Class<? extends Annotation> extractVariableAnnotationClass(AnnotatedElement member) {
        Class<? extends Annotation> annotationClass = null;
        for (Class<? extends Annotation> detectedAnnotationClass : VARIABLE_ANNOTATION_CLASSES) {
            if (!member.isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a member (" + member + ") that has both a " + annotationClass.getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    private void registerVariableAccessor(DescriptorPolicy descriptorPolicy, Class<? extends Annotation> variableAnnotationClass, MemberAccessor memberAccessor) {
        String memberName = memberAccessor.getName();
        if (this.declaredGenuineVariableDescriptorMap.containsKey(memberName) || this.declaredShadowVariableDescriptorMap.containsKey(memberName)) {
            VariableDescriptor duplicate = this.declaredGenuineVariableDescriptorMap.get(memberName);
            if (duplicate == null) {
                duplicate = this.declaredShadowVariableDescriptorMap.get(memberName);
            }
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + variableAnnotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member for variableDescriptor (" + duplicate + ").\n" + "  Verify that the annotation is not defined on both the field and its getter.");
        }
        if (variableAnnotationClass.equals(PlanningVariable.class)) {
            GenuineVariableDescriptor variableDescriptor = new GenuineVariableDescriptor(this, memberAccessor);
            this.declaredGenuineVariableDescriptorMap.put(memberName, variableDescriptor);
            variableDescriptor.processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(InverseRelationShadowVariable.class)) {
            InverseRelationShadowVariableDescriptor variableDescriptor = new InverseRelationShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(AnchorShadowVariable.class)) {
            AnchorShadowVariableDescriptor variableDescriptor = new AnchorShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(CustomShadowVariable.class)) {
            CustomShadowVariableDescriptor variableDescriptor = new CustomShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else {
            throw new IllegalStateException("The variableAnnotationClass (" + variableAnnotationClass + ") is not implemented.");
        }
    }

    public void linkInheritedEntityDescriptors(DescriptorPolicy descriptorPolicy) {
        this.inheritedEntityDescriptorList = new ArrayList<EntityDescriptor>(4);
        this.investigateParentsToLinkInherited(this.entityClass);
        this.createEffectiveVariableDescriptorMaps();
    }

    private void investigateParentsToLinkInherited(Class<?> investigateClass) {
        if (investigateClass == null || investigateClass.isArray()) {
            return;
        }
        this.linkInherited(investigateClass.getSuperclass());
        for (Class<?> superInterface : investigateClass.getInterfaces()) {
            this.linkInherited(superInterface);
        }
    }

    private void linkInherited(Class<?> investigateClass) {
        EntityDescriptor superEntityDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(investigateClass);
        if (superEntityDescriptor != null) {
            this.inheritedEntityDescriptorList.add(superEntityDescriptor);
        } else {
            this.investigateParentsToLinkInherited(investigateClass);
        }
    }

    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.linkShadowSources(descriptorPolicy);
        }
    }

    private void createEffectiveVariableDescriptorMaps() {
        this.effectiveGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor>(this.declaredGenuineVariableDescriptorMap.size());
        this.effectiveShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor>(this.declaredShadowVariableDescriptorMap.size());
        for (EntityDescriptor inheritedEntityDescriptor : this.inheritedEntityDescriptorList) {
            this.effectiveGenuineVariableDescriptorMap.putAll(inheritedEntityDescriptor.getGenuineVariableDescriptorMap());
            this.effectiveShadowVariableDescriptorMap.putAll(inheritedEntityDescriptor.getShadowVariableDescriptorMap());
        }
        this.effectiveGenuineVariableDescriptorMap.putAll(this.declaredGenuineVariableDescriptorMap);
        this.effectiveShadowVariableDescriptorMap.putAll(this.declaredShadowVariableDescriptorMap);
        this.effectiveVariableDescriptorMap = new LinkedHashMap<String, VariableDescriptor>(this.effectiveGenuineVariableDescriptorMap.size() + this.effectiveShadowVariableDescriptorMap.size());
        this.effectiveVariableDescriptorMap.putAll(this.effectiveGenuineVariableDescriptorMap);
        this.effectiveVariableDescriptorMap.putAll(this.effectiveShadowVariableDescriptorMap);
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public SelectionSorter getDecreasingDifficultySorter() {
        return this.decreasingDifficultySorter;
    }

    public boolean hasAnyDeclaredGenuineVariableDescriptor() {
        return !this.declaredGenuineVariableDescriptorMap.isEmpty();
    }

    public Collection<String> getGenuineVariableNameSet() {
        return this.effectiveGenuineVariableDescriptorMap.keySet();
    }

    public Map<String, GenuineVariableDescriptor> getGenuineVariableDescriptorMap() {
        return this.effectiveGenuineVariableDescriptorMap;
    }

    public Collection<GenuineVariableDescriptor> getGenuineVariableDescriptors() {
        return this.effectiveGenuineVariableDescriptorMap.values();
    }

    public List<GenuineVariableDescriptor> getGenuineVariableDescriptorList() {
        return new ArrayList<GenuineVariableDescriptor>(this.effectiveGenuineVariableDescriptorMap.values());
    }

    public boolean hasGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.containsKey(variableName);
    }

    public GenuineVariableDescriptor getGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.get(variableName);
    }

    public Map<String, ShadowVariableDescriptor> getShadowVariableDescriptorMap() {
        return this.effectiveShadowVariableDescriptorMap;
    }

    public boolean hasShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.containsKey(variableName);
    }

    public ShadowVariableDescriptor getShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.get(variableName);
    }

    public Map<String, VariableDescriptor> getVariableDescriptorMap() {
        return this.effectiveVariableDescriptorMap;
    }

    public Collection<VariableDescriptor> getVariableDescriptors() {
        return this.effectiveVariableDescriptorMap.values();
    }

    public boolean hasVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.containsKey(variableName);
    }

    public VariableDescriptor getVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.get(variableName);
    }

    public Collection<GenuineVariableDescriptor> getDeclaredGenuineVariableDescriptors() {
        return this.declaredGenuineVariableDescriptorMap.values();
    }

    public Collection<ShadowVariableDescriptor> getDeclaredShadowVariableDescriptors() {
        return this.declaredShadowVariableDescriptorMap.values();
    }

    public Collection<VariableDescriptor> getDeclaredVariableDescriptors() {
        ArrayList<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>(this.declaredGenuineVariableDescriptorMap.size() + this.declaredShadowVariableDescriptorMap.size());
        variableDescriptors.addAll(this.declaredGenuineVariableDescriptorMap.values());
        variableDescriptors.addAll(this.declaredShadowVariableDescriptorMap.values());
        return variableDescriptors;
    }

    public String buildInvalidVariableNameExceptionMessage(String variableName) {
        if (!ReflectionHelper.hasGetterMethod(this.entityClass, variableName)) {
            String exceptionMessage = "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") does not exists as a property (getter/setter) on that class.\n" + "Check the spelling of the variableName (" + variableName + ").";
            if (variableName.length() >= 2 && !Character.isUpperCase(variableName.charAt(0)) && Character.isUpperCase(variableName.charAt(1))) {
                String correctedVariableName = variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
                exceptionMessage = exceptionMessage + " It probably needs to be correctedVariableName (" + correctedVariableName + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            return exceptionMessage;
        }
        return "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") exists as a property (getter/setter) on that class," + " but not as an annotated as a planning variable.\n" + "Check if your planning entity's getter has the annotation " + PlanningVariable.class.getSimpleName() + " (or a shadow variable annotation).";
    }

    public boolean hasAnyChainedGenuineVariables() {
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isChained()) continue;
            return true;
        }
        return false;
    }

    public List<Object> extractEntities(Solution solution) {
        return this.solutionDescriptor.getEntityListByEntityClass(solution, this.entityClass);
    }

    public long getGenuineVariableCount() {
        return this.effectiveGenuineVariableDescriptorMap.size();
    }

    public long getProblemScale(Solution solution, Object entity) {
        long problemScale = 1L;
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getValueCount(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public int countReinitializableVariables(ScoreDirector scoreDirector, Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (!variableDescriptor.isReinitializable(scoreDirector, entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isMovable(ScoreDirector scoreDirector, Object entity) {
        return this.movableEntitySelectionFilter == null || this.movableEntitySelectionFilter.accept(scoreDirector, entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass.getName() + ")";
    }
}

