/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractFromPropertyValueRangeDescriptor
extends AbstractValueRangeDescriptor {
    protected final MemberAccessor memberAccessor;
    protected boolean collectionWrapping;
    protected boolean countable;

    public AbstractFromPropertyValueRangeDescriptor(GenuineVariableDescriptor variableDescriptor, boolean addNullInValueRange, MemberAccessor memberAccessor) {
        super(variableDescriptor, addNullInValueRange);
        this.memberAccessor = memberAccessor;
        ValueRangeProvider valueRangeProviderAnnotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The member (" + memberAccessor + ") must have a valueRangeProviderAnnotation (" + valueRangeProviderAnnotation + ").");
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (addNullInValueRange && !this.countable) {
            throw new IllegalStateException("The valueRangeDescriptor (" + this + ") is nullable, but not countable (" + this.countable + ").\n" + "Maybe the member (" + memberAccessor + ") should return " + CountableValueRange.class.getSimpleName() + ".");
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> type = this.memberAccessor.getType();
        this.collectionWrapping = Collection.class.isAssignableFrom(type);
        if (!this.collectionWrapping && !ValueRange.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that does not return a " + Collection.class.getSimpleName() + " or a " + ValueRange.class.getSimpleName() + ".");
        }
        this.countable = this.collectionWrapping || CountableValueRange.class.isAssignableFrom(type);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected ValueRange<?> readValueRange(Object bean) {
        ValueRange valueRange;
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return a null valueRangeObject (" + valueRangeObject + ").");
        }
        if (this.collectionWrapping) {
            List list = this.transformToList((Collection)valueRangeObject);
            valueRange = new ListValueRange(list);
        } else {
            valueRange = (ValueRange)valueRangeObject;
        }
        valueRange = this.doNullInValueRangeWrapping(valueRange);
        if (valueRange.isEmpty()) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return an empty valueRange (" + valueRangeObject + ").\n" + "  If this a valid dataset, apply overconstrained planning as described in the documentation.");
        }
        return valueRange;
    }

    private <T> List<T> transformToList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }
}

