/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.StatefulVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotificationType;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class VariableListenerSupport
implements SupplyManager {
    protected final InnerScoreDirector scoreDirector;
    protected final Map<VariableDescriptor, List<VariableListenerNotifiable>> sourceVariableToNotifiableMap;
    protected final Map<EntityDescriptor, List<VariableListenerNotifiable>> sourceEntityToNotifiableMap;
    protected final Map<Demand, Supply> supplyMap;
    protected int nextGlobalOrder = 0;
    protected SortedMap<VariableListenerNotifiable, Set<VariableListenerNotification>> notificationQueueMap;
    protected boolean notificationQueuesAreEmpty;

    public VariableListenerSupport(InnerScoreDirector scoreDirector) {
        this.scoreDirector = scoreDirector;
        this.sourceVariableToNotifiableMap = new LinkedHashMap<VariableDescriptor, List<VariableListenerNotifiable>>();
        this.sourceEntityToNotifiableMap = new LinkedHashMap<EntityDescriptor, List<VariableListenerNotifiable>>();
        this.supplyMap = new LinkedHashMap<Demand, Supply>();
    }

    public void linkVariableListeners() {
        this.notificationQueueMap = new TreeMap<VariableListenerNotifiable, Set<VariableListenerNotification>>();
        this.notificationQueuesAreEmpty = true;
        for (EntityDescriptor entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                ArrayList variableNotifiableList = new ArrayList();
                this.sourceVariableToNotifiableMap.put(variableDescriptor, variableNotifiableList);
            }
            ArrayList entityNotifiableList = new ArrayList();
            this.sourceEntityToNotifiableMap.put(entityDescriptor, entityNotifiableList);
        }
        for (EntityDescriptor entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (ShadowVariableDescriptor shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                if (!shadowVariableDescriptor.hasVariableListener(this.scoreDirector)) continue;
                VariableListener variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
                this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), variableListener);
                int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
                if (this.nextGlobalOrder <= globalOrder) {
                    this.nextGlobalOrder = globalOrder + 1;
                }
                VariableListenerNotifiable notifiable = new VariableListenerNotifiable(variableListener, globalOrder);
                for (VariableDescriptor source : shadowVariableDescriptor.getSourceVariableDescriptorList()) {
                    List<VariableListenerNotifiable> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                    variableNotifiableList.add(notifiable);
                    List<VariableListenerNotifiable> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                    if (entityNotifiableList.contains(notifiable)) continue;
                    entityNotifiableList.add(notifiable);
                }
                LinkedHashSet notificationQueue = new LinkedHashSet();
                this.notificationQueueMap.put(notifiable, notificationQueue);
            }
        }
    }

    @Override
    public <S extends Supply> S demand(Demand<S> demand) {
        Supply supply = this.supplyMap.get(demand);
        if (supply == null) {
            supply = demand.createExternalizedSupply(this.scoreDirector);
            if (supply instanceof StatefulVariableListener) {
                StatefulVariableListener variableListener = (StatefulVariableListener)supply;
                variableListener.resetWorkingSolution(this.scoreDirector);
                VariableDescriptor source = variableListener.getSourceVariableDescriptor();
                VariableListenerNotifiable notifiable = new VariableListenerNotifiable(variableListener, this.nextGlobalOrder);
                ++this.nextGlobalOrder;
                List<VariableListenerNotifiable> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                variableNotifiableList.add(notifiable);
                List<VariableListenerNotifiable> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                if (!entityNotifiableList.contains(notifiable)) {
                    entityNotifiableList.add(notifiable);
                }
                LinkedHashSet notificationQueue = new LinkedHashSet();
                this.notificationQueueMap.put(notifiable, notificationQueue);
            }
            this.supplyMap.put(demand, supply);
        }
        return (S)supply;
    }

    public void resetWorkingSolution() {
        for (VariableListenerNotifiable notifiable : this.notificationQueueMap.keySet()) {
            VariableListener variableListener = notifiable.getVariableListener();
            if (!(variableListener instanceof StatefulVariableListener)) continue;
            ((StatefulVariableListener)variableListener).resetWorkingSolution(this.scoreDirector);
        }
    }

    public void clearWorkingSolution() {
        for (VariableListenerNotifiable notifiable : this.notificationQueueMap.keySet()) {
            VariableListener variableListener = notifiable.getVariableListener();
            if (!(variableListener instanceof StatefulVariableListener)) continue;
            ((StatefulVariableListener)variableListener).clearWorkingSolution(this.scoreDirector);
        }
    }

    public void beforeEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        List<VariableListenerNotifiable> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Set notificationQueue = (Set)this.notificationQueueMap.get(notifiable);
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_ADDED));
            if (!added) continue;
            notifiable.getVariableListener().beforeEntityAdded(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
    }

    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        List<VariableListenerNotifiable> notifiableList = this.sourceVariableToNotifiableMap.get(variableDescriptor);
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Set notificationQueue = (Set)this.notificationQueueMap.get(notifiable);
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.VARIABLE_CHANGED));
            if (!added) continue;
            notifiable.getVariableListener().beforeVariableChanged(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
    }

    public void beforeEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        List<VariableListenerNotifiable> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Set notificationQueue = (Set)this.notificationQueueMap.get(notifiable);
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_REMOVED));
            if (!added) continue;
            notifiable.getVariableListener().beforeEntityRemoved(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (Map.Entry<VariableListenerNotifiable, Set<VariableListenerNotification>> entry : this.notificationQueueMap.entrySet()) {
            VariableListenerNotifiable notifiable = entry.getKey();
            Set<VariableListenerNotification> notificationQueue = entry.getValue();
            VariableListener variableListener = notifiable.getVariableListener();
            Iterator<VariableListenerNotification> it = notificationQueue.iterator();
            while (it.hasNext()) {
                VariableListenerNotification notification = it.next();
                Object entity = notification.getEntity();
                switch (notification.getType()) {
                    case ENTITY_ADDED: {
                        variableListener.afterEntityAdded(this.scoreDirector, entity);
                        break;
                    }
                    case VARIABLE_CHANGED: {
                        variableListener.afterVariableChanged(this.scoreDirector, entity);
                        break;
                    }
                    case ENTITY_REMOVED: {
                        variableListener.afterEntityRemoved(this.scoreDirector, entity);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The variableListenerNotificationType (" + (Object)((Object)notification.getType()) + ") is not implemented.");
                    }
                }
                it.remove();
            }
        }
        this.notificationQueuesAreEmpty = true;
    }

    public void triggerAllVariableListeners() {
        SolutionDescriptor solutionDescriptor = this.scoreDirector.getSolutionDescriptor();
        List<Object> entityList = this.scoreDirector.getWorkingEntityList();
        for (Object entity : entityList) {
            EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                this.beforeVariableChanged(variableDescriptor, entity);
                this.afterVariableChanged(variableDescriptor, entity);
            }
        }
        this.triggerVariableListenersInNotificationQueues();
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\n" + "Maybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called" + " without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners()," + " before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

