/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerSupport;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<F extends AbstractScoreDirectorFactory>
implements InnerScoreDirector,
Cloneable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final F scoreDirectorFactory;
    protected final boolean constraintMatchEnabledPreference;
    protected final VariableListenerSupport variableListenerSupport;
    protected Solution workingSolution;
    protected long workingEntityListRevision = 0L;
    protected boolean allChangesWillBeUndoneBeforeStepEnds = false;
    protected long calculateCount = 0L;

    protected AbstractScoreDirector(F scoreDirectorFactory, boolean constraintMatchEnabledPreference) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
        this.variableListenerSupport = new VariableListenerSupport(this);
        this.variableListenerSupport.linkVariableListeners();
    }

    public F getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    public boolean isAllChangesWillBeUndoneBeforeStepEnds() {
        return this.allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculateCount() {
        return this.calculateCount;
    }

    @Override
    public void resetCalculateCount() {
        this.calculateCount = 0L;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.variableListenerSupport.resetWorkingSolution();
        this.setWorkingEntityListDirty();
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution cloneWorkingSolution() {
        return this.cloneSolution(this.workingSolution);
    }

    @Override
    public Solution cloneSolution(Solution originalSolution) {
        SolutionDescriptor solutionDescriptor = this.getSolutionDescriptor();
        Solution cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!ObjectUtils.equals(originalSolution.getScore(), cloneSolution.getScore())) {
                throw new IllegalStateException("Cloning corruption: the original's score (" + originalSolution.getScore() + ") is different from the clone's score (" + cloneSolution.getScore() + ").\n" + "Check the " + SolutionCloner.class.getSimpleName() + ".");
            }
            List<Object> originalEntityList = solutionDescriptor.getEntityList(originalSolution);
            IdentityHashMap originalEntityMap = new IdentityHashMap(originalEntityList.size());
            for (Object originalEntity : originalEntityList) {
                originalEntityMap.put(originalEntity, null);
            }
            for (Object cloneEntity : solutionDescriptor.getEntityList(cloneSolution)) {
                if (!originalEntityMap.containsKey(cloneEntity)) continue;
                throw new IllegalStateException("Cloning corruption: the same entity (" + cloneEntity + ") is present in both the original and the clone.\n" + "So when a planning variable in the original solution changes, " + "the cloned solution will change too.\n" + "Check the " + SolutionCloner.class.getSimpleName() + ".");
            }
        }
        return cloneSolution;
    }

    @Override
    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.workingSolution);
    }

    @Override
    public List<Object> getWorkingEntityList() {
        return this.getSolutionDescriptor().getEntityList(this.workingSolution);
    }

    @Override
    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.workingSolution);
    }

    @Override
    public int countWorkingSolutionUninitializedVariables() {
        return this.getSolutionDescriptor().countUninitializedVariables(this.workingSolution);
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    protected void setCalculatedScore(Score score) {
        this.workingSolution.setScore(score);
        ++this.calculateCount;
    }

    @Override
    public AbstractScoreDirector clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.constraintMatchEnabledPreference);
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public void dispose() {
        this.variableListenerSupport.clearWorkingSolution();
    }

    @Override
    public final void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void beforeVariableChanged(Object entity, String variableName) {
        VariableDescriptor variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void afterVariableChanged(Object entity, String variableName) {
        VariableDescriptor variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    public void afterEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.afterEntityAdded(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.variableListenerSupport.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void changeVariableFacade(VariableDescriptor variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    public void beforeEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    public void afterEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.afterEntityRemoved(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore  (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertVariableListenersDoNotAffectWorkingScore(Score expectedWorkingScore) {
        this.variableListenerSupport.triggerAllVariableListeners();
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("VariableListener corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore  (" + workingScore + ") after all VariableListeners were triggered without changes to the genuine variables.\n" + "A VariableListener probably changed a shadow variable," + " despite that the genuine variable didn't change," + " which means the shadow variable's original value is probably wrong.");
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        InnerScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        InnerScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector(true);
        uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        if (!workingScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
            uncorruptedScoreDirector.dispose();
            throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis);
        }
        uncorruptedScoreDirector.dispose();
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        int count;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "  Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n" + "  Check your score constraints manually.";
        }
        Collection<ConstraintMatchTotal> corruptedConstraintMatchTotals = this.getConstraintMatchTotals();
        Collection<ConstraintMatchTotal> uncorruptedConstraintMatchTotals = uncorruptedScoreDirector.getConstraintMatchTotals();
        Map<List<Object>, ConstraintMatch> corruptedMap = this.createConstraintMatchMap(corruptedConstraintMatchTotals);
        LinkedHashMap<List<Object>, ConstraintMatch> excessMap = new LinkedHashMap<List<Object>, ConstraintMatch>(corruptedMap);
        Map<List<Object>, ConstraintMatch> missingMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotals);
        excessMap.keySet().removeAll(missingMap.keySet());
        missingMap.keySet().removeAll(corruptedMap.keySet());
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        if (excessMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(excessMap.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            count = 0;
            for (ConstraintMatch constraintMatch : excessMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(excessMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(missingMap.size()).append(" ConstraintMatch(s) which are missing:\n");
            count = 0;
            for (ConstraintMatch constraintMatch : missingMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(missingMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (excessMap.isEmpty() && missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) in excess or missing. That could be a bug in this class (").append(this.getClass()).append(").\n");
        }
        analysis.append("  Check your score constraints.");
        return analysis.toString();
    }

    private Map<List<Object>, ConstraintMatch> createConstraintMatchMap(Collection<ConstraintMatchTotal> constraintMatchTotals) {
        LinkedHashMap<List<Object>, ConstraintMatch> constraintMatchMap = new LinkedHashMap<List<Object>, ConstraintMatch>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                ConstraintMatch previousConstraintMatch = constraintMatchMap.put(Arrays.asList(constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatchTotal.getScoreLevel(), constraintMatch.getJustificationList(), constraintMatch.getWeightAsNumber()), constraintMatch);
                if (previousConstraintMatch == null) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculateCount + ")";
    }
}

