/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.solver.SolverConfig;

@XStreamAlias(value="solverBenchmark")
public class SolverBenchmarkConfig {
    private String name = null;
    @XStreamAlias(value="solver")
    private SolverConfig solverConfig = null;
    @XStreamAlias(value="problemBenchmarks")
    private ProblemBenchmarksConfig problemBenchmarksConfig = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public ProblemBenchmarksConfig getProblemBenchmarksConfig() {
        return this.problemBenchmarksConfig;
    }

    public void setProblemBenchmarksConfig(ProblemBenchmarksConfig problemBenchmarksConfig) {
        this.problemBenchmarksConfig = problemBenchmarksConfig;
    }

    public void buildSolverBenchmark(PlannerBenchmarkResult plannerBenchmark) {
        this.validate();
        SolverBenchmarkResult solverBenchmarkResult = new SolverBenchmarkResult(plannerBenchmark);
        solverBenchmarkResult.setName(this.name);
        solverBenchmarkResult.setSolverConfig(this.solverConfig);
        solverBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        ProblemBenchmarksConfig problemBenchmarksConfig_ = this.problemBenchmarksConfig == null ? new ProblemBenchmarksConfig() : this.problemBenchmarksConfig;
        plannerBenchmark.getSolverBenchmarkResultList().add(solverBenchmarkResult);
        problemBenchmarksConfig_.buildProblemBenchmarkList(solverBenchmarkResult);
    }

    protected void validate() {
        if (!PlannerBenchmarkConfig.VALID_NAME_PATTERN.matcher(this.name).matches()) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + PlannerBenchmarkConfig.VALID_NAME_PATTERN.pattern() + ")" + " which might cause an illegal filename.");
        }
        if (!this.name.trim().equals(this.name)) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because it starts or ends with whitespace.");
        }
    }

    public void inherit(SolverBenchmarkConfig inheritedConfig) {
        if (this.solverConfig == null) {
            this.solverConfig = inheritedConfig.getSolverConfig();
        } else if (inheritedConfig.getSolverConfig() != null) {
            this.solverConfig.inherit(inheritedConfig.getSolverConfig());
        }
        if (this.problemBenchmarksConfig == null) {
            this.problemBenchmarksConfig = inheritedConfig.getProblemBenchmarksConfig();
        } else if (inheritedConfig.getProblemBenchmarksConfig() != null) {
            this.problemBenchmarksConfig.inherit(inheritedConfig.getProblemBenchmarksConfig());
        }
    }
}

