/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;
import org.optaplanner.benchmark.impl.ranking.SolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.report.WebsiteResourceUtils;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;

public class BenchmarkReport {
    public static final int CHARTED_SCORE_LEVEL_SIZE = 15;
    public static final int LOG_SCALE_MIN_DATASETS_COUNT = 5;
    private final PlannerBenchmarkResult plannerBenchmarkResult;
    private Locale locale = null;
    private Comparator<SolverBenchmarkResult> solverRankingComparator = null;
    private SolverRankingWeightFactory solverRankingWeightFactory = null;
    private File summaryDirectory = null;
    private List<File> bestScoreSummaryChartFileList = null;
    private List<File> bestScoreScalabilitySummaryChartFileList = null;
    private List<File> winningScoreDifferenceSummaryChartFileList = null;
    private List<File> worstScoreDifferencePercentageSummaryChartFileList = null;
    private File averageCalculateCountSummaryChartFile = null;
    private File timeSpentSummaryChartFile = null;
    private File timeSpentScalabilitySummaryChartFile = null;
    private List<File> bestScorePerTimeSpentSummaryChartFileList = null;
    private Integer defaultShownScoreLevelIndex = null;
    private List<String> warningList = null;
    private File htmlOverviewFile = null;

    public BenchmarkReport(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Comparator<SolverBenchmarkResult> getSolverRankingComparator() {
        return this.solverRankingComparator;
    }

    public void setSolverRankingComparator(Comparator<SolverBenchmarkResult> solverRankingComparator) {
        this.solverRankingComparator = solverRankingComparator;
    }

    public SolverRankingWeightFactory getSolverRankingWeightFactory() {
        return this.solverRankingWeightFactory;
    }

    public void setSolverRankingWeightFactory(SolverRankingWeightFactory solverRankingWeightFactory) {
        this.solverRankingWeightFactory = solverRankingWeightFactory;
    }

    public File getSummaryDirectory() {
        return this.summaryDirectory;
    }

    public List<File> getBestScoreSummaryChartFileList() {
        return this.bestScoreSummaryChartFileList;
    }

    public List<File> getBestScoreScalabilitySummaryChartFileList() {
        return this.bestScoreScalabilitySummaryChartFileList;
    }

    public List<File> getWinningScoreDifferenceSummaryChartFileList() {
        return this.winningScoreDifferenceSummaryChartFileList;
    }

    public List<File> getWorstScoreDifferencePercentageSummaryChartFileList() {
        return this.worstScoreDifferencePercentageSummaryChartFileList;
    }

    public File getAverageCalculateCountSummaryChartFile() {
        return this.averageCalculateCountSummaryChartFile;
    }

    public File getTimeSpentSummaryChartFile() {
        return this.timeSpentSummaryChartFile;
    }

    public File getTimeSpentScalabilitySummaryChartFile() {
        return this.timeSpentScalabilitySummaryChartFile;
    }

    public List<File> getBestScorePerTimeSpentSummaryChartFileList() {
        return this.bestScorePerTimeSpentSummaryChartFileList;
    }

    public Integer getDefaultShownScoreLevelIndex() {
        return this.defaultShownScoreLevelIndex;
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public File getHtmlOverviewFile() {
        return this.htmlOverviewFile;
    }

    public String getRelativePathToBenchmarkReportDirectory(File file) {
        String benchmarkReportDirectoryPath = this.plannerBenchmarkResult.getBenchmarkReportDirectory().getAbsoluteFile().toURI().getPath();
        String filePath = file.getAbsoluteFile().toURI().getPath();
        if (!filePath.startsWith(benchmarkReportDirectoryPath)) {
            throw new IllegalArgumentException("The filePath (" + filePath + ") does not start with the benchmarkReportDirectoryPath (" + benchmarkReportDirectoryPath + ").");
        }
        String relativePath = filePath.substring(benchmarkReportDirectoryPath.length());
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public void writeReport() {
        this.summaryDirectory = new File(this.plannerBenchmarkResult.getBenchmarkReportDirectory(), "summary");
        this.summaryDirectory.mkdir();
        this.plannerBenchmarkResult.accumulateResults(this);
        this.fillWarningList();
        this.writeBestScoreSummaryCharts();
        this.writeBestScoreScalabilitySummaryChart();
        this.writeWinningScoreDifferenceSummaryChart();
        this.writeWorstScoreDifferencePercentageSummaryChart();
        this.writeAverageCalculateCountPerSecondSummaryChart();
        this.writeTimeSpentSummaryChart();
        this.writeTimeSpentScalabilitySummaryChart();
        this.writeBestScorePerTimeSpentSummaryChart();
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            if (!problemBenchmarkResult.hasAnySuccess()) continue;
            for (ProblemStatistic problemStatistic : problemBenchmarkResult.getProblemStatisticList()) {
                problemStatistic.writeGraphFiles(this);
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                for (PureSingleStatistic pureSingleStatistic : singleBenchmarkResult.getPureSingleStatisticList()) {
                    pureSingleStatistic.writeGraphFiles(this);
                }
            }
        }
        this.determineDefaultShownScoreLevelIndex();
        this.writeHtmlOverviewFile();
    }

    protected void fillWarningList() {
        this.warningList = new ArrayList<String>();
        String javaVmName = System.getProperty("java.vm.name");
        if (javaVmName != null && javaVmName.contains("Client VM")) {
            this.warningList.add("The Java VM (" + javaVmName + ") is the Client VM." + " Consider starting the java process with the argument \"-server\" to get better results.");
        }
        if (this.plannerBenchmarkResult.getParallelBenchmarkCount() != null && this.plannerBenchmarkResult.getAvailableProcessors() != null && this.plannerBenchmarkResult.getParallelBenchmarkCount() > this.plannerBenchmarkResult.getAvailableProcessors()) {
            this.warningList.add("The parallelBenchmarkCount (" + this.plannerBenchmarkResult.getParallelBenchmarkCount() + ") is higher than the number of availableProcessors (" + this.plannerBenchmarkResult.getAvailableProcessors() + ").");
        }
    }

    private void writeBestScoreSummaryCharts() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String planningProblemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.isSuccess()) continue;
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmarkResult.getScore());
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.bestScoreSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScoreSummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScoreSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeBestScoreScalabilitySummaryChart() {
        ArrayList seriesListList = new ArrayList(15);
        int solverBenchmarkIndex = 0;
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String string = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                long problemScale = singleBenchmarkResult.getProblemBenchmarkResult().getProblemScale();
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmarkResult.getScore());
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= seriesListList.size()) {
                        seriesListList.add(new ArrayList(this.plannerBenchmarkResult.getSolverBenchmarkResultList().size()));
                    }
                    List seriesList = (List)seriesListList.get(i);
                    while (solverBenchmarkIndex >= seriesList.size()) {
                        seriesList.add(new XYSeries((Comparable)((Object)string)));
                    }
                    ((XYSeries)seriesList.get(solverBenchmarkIndex)).add((double)problemScale, levelValues[i]);
                }
            }
            ++solverBenchmarkIndex;
        }
        this.bestScoreScalabilitySummaryChartFileList = new ArrayList<File>(seriesListList.size());
        int scoreLevelIndex = 0;
        for (List list : seriesListList) {
            XYPlot plot = this.createScalabilityPlot(list, "Problem scale", NumberFormat.getInstance(this.locale), "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score scalability level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScoreScalabilitySummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScoreScalabilitySummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWinningScoreDifferenceSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String planningProblemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.isSuccess()) continue;
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmarkResult.getWinningScoreDifference());
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.winningScoreDifferenceSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Winning score difference level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Winning score difference level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.winningScoreDifferenceSummaryChartFileList.add(this.writeChartToImageFile(chart, "winningScoreDifferenceSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWorstScoreDifferencePercentageSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String planningProblemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.isSuccess()) continue;
                double[] levelValues = singleBenchmarkResult.getWorstScoreDifferencePercentage().getPercentageLevels();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.worstScoreDifferencePercentageSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Worst score difference percentage level " + scoreLevelIndex, NumberFormat.getPercentInstance(this.locale));
            JFreeChart chart = new JFreeChart("Worst score difference percentage level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.worstScoreDifferencePercentageSummaryChartFileList.add(this.writeChartToImageFile(chart, "worstScoreDifferencePercentageSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeAverageCalculateCountPerSecondSummaryChart() {
        ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(this.plannerBenchmarkResult.getSolverBenchmarkResultList().size());
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                long problemScale = singleBenchmarkResult.getProblemBenchmarkResult().getProblemScale();
                long averageCalculateCountPerSecond = singleBenchmarkResult.getAverageCalculateCountPerSecond();
                series.add((Number)problemScale, (Number)averageCalculateCountPerSecond);
            }
            seriesList.add(series);
        }
        XYPlot plot = this.createScalabilityPlot(seriesList, "Problem scale", NumberFormat.getInstance(this.locale), "Average calculate count per second", NumberFormat.getInstance(this.locale));
        JFreeChart chart = new JFreeChart("Average calculate count summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.averageCalculateCountSummaryChartFile = this.writeChartToImageFile(chart, "averageCalculateCountSummary");
    }

    private void writeTimeSpentSummaryChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String planningProblemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.isSuccess()) continue;
                long timeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                dataset.addValue((double)timeMillisSpent, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryPlot plot = this.createBarChartPlot(dataset, "Time spent", new MillisecondsSpentNumberFormat(this.locale));
        JFreeChart chart = new JFreeChart("Time spent summary (lower time is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.timeSpentSummaryChartFile = this.writeChartToImageFile(chart, "timeSpentSummary");
    }

    private void writeTimeSpentScalabilitySummaryChart() {
        ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(this.plannerBenchmarkResult.getSolverBenchmarkResultList().size());
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                long problemScale = singleBenchmarkResult.getProblemBenchmarkResult().getProblemScale();
                long timeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                series.add((Number)problemScale, (Number)timeMillisSpent);
            }
            seriesList.add(series);
        }
        XYPlot plot = this.createScalabilityPlot(seriesList, "Problem scale", NumberFormat.getInstance(this.locale), "Time spent", new MillisecondsSpentNumberFormat(this.locale));
        JFreeChart chart = new JFreeChart("Time spent scalability summary (lower is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.timeSpentScalabilitySummaryChartFile = this.writeChartToImageFile(chart, "timeSpentScalabilitySummary");
    }

    private void writeBestScorePerTimeSpentSummaryChart() {
        ArrayList seriesListList = new ArrayList(15);
        int solverBenchmarkIndex = 0;
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String string = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                long timeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmarkResult.getScore());
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= seriesListList.size()) {
                        seriesListList.add(new ArrayList(this.plannerBenchmarkResult.getSolverBenchmarkResultList().size()));
                    }
                    List seriesList = (List)seriesListList.get(i);
                    while (solverBenchmarkIndex >= seriesList.size()) {
                        seriesList.add(new XYSeries((Comparable)((Object)string)));
                    }
                    ((XYSeries)seriesList.get(solverBenchmarkIndex)).add((Number)timeMillisSpent, (Number)levelValues[i]);
                }
            }
            ++solverBenchmarkIndex;
        }
        this.bestScorePerTimeSpentSummaryChartFileList = new ArrayList<File>(seriesListList.size());
        int scoreLevelIndex = 0;
        for (List list : seriesListList) {
            XYPlot plot = this.createScalabilityPlot(list, "Time spent", new MillisecondsSpentNumberFormat(this.locale), "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score per time spent level " + scoreLevelIndex + " summary (higher left is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScorePerTimeSpentSummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScorePerTimeSpentSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private CategoryPlot createBarChartPlot(DefaultCategoryDataset dataset, String yAxisLabel, NumberFormat yAxisNumberFormat) {
        CategoryAxis xAxis = new CategoryAxis("Data");
        xAxis.setCategoryMargin(0.4);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setNumberFormatOverride(yAxisNumberFormat);
        BarRenderer renderer = this.createBarChartRenderer(yAxisNumberFormat);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private BarRenderer createBarChartRenderer(NumberFormat numberFormat) {
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", numberFormat));
        renderer.setBaseItemLabelsVisible(true);
        return renderer;
    }

    private XYPlot createScalabilityPlot(List<XYSeries> seriesList, String xAxisLabel, NumberFormat xAxisNumberFormat, String yAxisLabel, NumberFormat yAxisNumberFormat) {
        NumberAxis xAxis;
        if (this.useLogarithmicProblemScale(seriesList)) {
            LogarithmicAxis logarithmicAxis = new LogarithmicAxis(xAxisLabel + " (logarithmic)");
            logarithmicAxis.setAllowNegativesFlag(true);
            xAxis = logarithmicAxis;
        } else {
            xAxis = new NumberAxis(xAxisLabel);
        }
        xAxis.setNumberFormatOverride(xAxisNumberFormat);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setNumberFormatOverride(yAxisNumberFormat);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (XYSeries series : seriesList) {
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            XYItemRenderer renderer = this.createScalabilityPlotRenderer(yAxisNumberFormat);
            plot.setRenderer(seriesIndex, renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    protected boolean useLogarithmicProblemScale(List<XYSeries> seriesList) {
        TreeSet<Double> xValueSet = new TreeSet<Double>();
        int xValueListSize = 0;
        for (XYSeries series : seriesList) {
            for (XYDataItem dataItem : series.getItems()) {
                xValueSet.add(dataItem.getXValue());
                ++xValueListSize;
            }
        }
        if (xValueListSize < 5) {
            return false;
        }
        double threshold = 0.2 * ((Double)xValueSet.last() - (Double)xValueSet.first());
        int belowThresholdCount = xValueSet.headSet(threshold).size();
        return (double)belowThresholdCount >= 0.6 * (double)xValueSet.size();
    }

    private XYItemRenderer createScalabilityPlotRenderer(NumberFormat numberFormat) {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
        return renderer;
    }

    private File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File summaryChartFile = new File(this.summaryDirectory, fileNameBase + ".png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(summaryChartFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing summaryChartFile: " + summaryChartFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return summaryChartFile;
    }

    private void determineDefaultShownScoreLevelIndex() {
        this.defaultShownScoreLevelIndex = Integer.MAX_VALUE;
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            if (!problemBenchmarkResult.hasAnySuccess()) continue;
            double[] winningScoreLevels = ScoreUtils.extractLevelDoubles((Score)problemBenchmarkResult.getWinningSingleBenchmarkResult().getScore());
            int[] differenceCount = new int[winningScoreLevels.length];
            for (int i = 0; i < differenceCount.length; ++i) {
                differenceCount[i] = 0;
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.isSuccess()) continue;
                double[] scoreLevels = ScoreUtils.extractLevelDoubles((Score)singleBenchmarkResult.getScore());
                for (int i = 0; i < scoreLevels.length; ++i) {
                    if (scoreLevels[i] == winningScoreLevels[i]) continue;
                    differenceCount[i] = differenceCount[i] + 1;
                }
            }
            int firstInterestingLevel = differenceCount.length - 1;
            for (int i = 0; i < differenceCount.length; ++i) {
                if (differenceCount[i] <= 0) continue;
                firstInterestingLevel = i;
                break;
            }
            if (this.defaultShownScoreLevelIndex <= firstInterestingLevel) continue;
            this.defaultShownScoreLevelIndex = firstInterestingLevel;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeHtmlOverviewFile() {
        File benchmarkReportDirectory = this.plannerBenchmarkResult.getBenchmarkReportDirectory();
        WebsiteResourceUtils.copyResourcesTo(benchmarkReportDirectory);
        this.htmlOverviewFile = new File(benchmarkReportDirectory, "index.html");
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setLocale(this.locale);
        freemarkerCfg.setClassForTemplateLoading(BenchmarkReport.class, "");
        String templateFilename = "benchmarkReport.html.ftl";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("benchmarkReport", this);
        model.put("reportHelper", new ReportHelper());
        OutputStreamWriter writer = null;
        try {
            Template template = freemarkerCfg.getTemplate(templateFilename);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOverviewFile), "UTF-8");
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write htmlOverviewFile (" + this.htmlOverviewFile + ").", e);
                catch (TemplateException e2) {
                    throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to htmlOverviewFile (" + this.htmlOverviewFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

