/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.lambda;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import org.optaplanner.core.impl.domain.common.accessor.lambda.BooleanPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.BytePropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.CharPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.DoublePropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.FloatPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.IntPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.LongPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.ObjectPropertySetterFactory;
import org.optaplanner.core.impl.domain.common.accessor.lambda.ShortPropertySetterFactory;

public abstract class PropertySetterFactory<T> {
    private Method setterMethod;
    private Class<?> propertyType;
    private MethodHandles.Lookup lookup;
    protected T setterFunction;

    public static BiConsumer createSetterFunction(Method setterMethod, Class<?> propertyType, MethodHandles.Lookup lookup) {
        PropertySetterFactory propertySetterFactory;
        if (Object.class.isAssignableFrom(propertyType)) {
            propertySetterFactory = new ObjectPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Boolean.TYPE)) {
            propertySetterFactory = new BooleanPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Integer.TYPE)) {
            propertySetterFactory = new IntPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Long.TYPE)) {
            propertySetterFactory = new LongPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Float.TYPE)) {
            propertySetterFactory = new FloatPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Double.TYPE)) {
            propertySetterFactory = new DoublePropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Character.TYPE)) {
            propertySetterFactory = new CharPropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Byte.TYPE)) {
            propertySetterFactory = new BytePropertySetterFactory(setterMethod, propertyType, lookup);
        } else if (propertyType.equals(Short.TYPE)) {
            propertySetterFactory = new ShortPropertySetterFactory(setterMethod, propertyType, lookup);
        } else {
            throw new IllegalArgumentException("Unsupported property type (" + propertyType + ").");
        }
        return ((PropertySetterFactory)propertySetterFactory).wrapSetterFunction();
    }

    protected PropertySetterFactory(Method setterMethod, Class<?> propertyType, MethodHandles.Lookup lookup) {
        this.setterMethod = setterMethod;
        this.propertyType = propertyType;
        this.lookup = lookup;
        this.setterFunction = this.createSetterFunction();
    }

    private T createSetterFunction() {
        CallSite setterSite;
        if (this.setterMethod == null) {
            return null;
        }
        Class<?> declaringClass = this.setterMethod.getDeclaringClass();
        try {
            setterSite = LambdaMetafactory.metafactory(this.lookup, "accept", MethodType.methodType(this.getConsumerType()), MethodType.methodType(Void.TYPE, Object.class, this.getSetterParameterType()), this.lookup.findVirtual(declaringClass, this.setterMethod.getName(), MethodType.methodType(Void.TYPE, this.propertyType)), MethodType.methodType(Void.TYPE, declaringClass, this.propertyType));
        }
        catch (IllegalAccessException | NoSuchMethodException | LambdaConversionException e) {
            throw new IllegalArgumentException("Lambda creation failed for setterMethod (" + this.setterMethod + ").", e);
        }
        try {
            return this.functionFromCallSite(setterSite);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Lambda creation failed for setterMethod (" + this.setterMethod + ").", e);
        }
    }

    protected abstract T functionFromCallSite(CallSite var1) throws Throwable;

    protected abstract Class<?> getSetterParameterType();

    protected abstract Class<T> getConsumerType();

    protected abstract BiConsumer wrapSetterFunction();
}

