/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftBigDecimalScoreHolder
extends AbstractScoreHolder<HardMediumSoftBigDecimalScore> {
    protected final Map<Rule, BiConsumer<RuleContext, BigDecimal>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BigDecimal>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardMediumSoftBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardMediumSoftBigDecimalScore>>();
    protected BigDecimal hardScore;
    protected BigDecimal mediumScore;
    protected BigDecimal softScore;

    public HardMediumSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftBigDecimalScore.ZERO);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, BigDecimal> matchExecutor = constraintWeight.equals(HardMediumSoftBigDecimalScore.ZERO) ? (kcontext, matchWeight) -> {} : (constraintWeight.getMediumScore().equals(BigDecimal.ZERO) && constraintWeight.getSoftScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply((BigDecimal)matchWeight)) : (constraintWeight.getHardScore().equals(BigDecimal.ZERO) && constraintWeight.getSoftScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addMediumConstraintMatch((RuleContext)kcontext, constraintWeight.getMediumScore().multiply((BigDecimal)matchWeight)) : (constraintWeight.getHardScore().equals(BigDecimal.ZERO) && constraintWeight.getMediumScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore().multiply((BigDecimal)matchWeight)) : (kcontext, matchWeight) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply((BigDecimal)matchWeight), constraintWeight.getMediumScore().multiply((BigDecimal)matchWeight), constraintWeight.getSoftScore().multiply((BigDecimal)matchWeight)))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore().multiply(weightMultiplier.getHardScore()), constraintWeight.getMediumScore().multiply(weightMultiplier.getMediumScore()), constraintWeight.getSoftScore().multiply(weightMultiplier.getSoftScore())));
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.reward(kcontext, weightMultiplier.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.reward(kcontext, hardWeightMultiplier.negate(), mediumWeightMultiplier.negate(), softWeightMultiplier.negate());
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE);
    }

    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BigDecimal> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardMediumSoftBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftBigDecimalScore.of(hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardMediumSoftBigDecimalScore.of(hardWeight, BigDecimal.ZERO, BigDecimal.ZERO));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, BigDecimal mediumWeight) {
        this.mediumScore = this.mediumScore == null ? mediumWeight : this.mediumScore.add(mediumWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
        }, () -> HardMediumSoftBigDecimalScore.of(BigDecimal.ZERO, mediumWeight, BigDecimal.ZERO));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.of(BigDecimal.ZERO, BigDecimal.ZERO, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal mediumWeight, BigDecimal softWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.mediumScore = this.mediumScore == null ? mediumWeight : this.mediumScore.add(mediumWeight);
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.of(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public HardMediumSoftBigDecimalScore extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore == null ? BigDecimal.ZERO : this.hardScore, this.mediumScore == null ? BigDecimal.ZERO : this.mediumScore, this.softScore == null ? BigDecimal.ZERO : this.softScore);
    }
}

