/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.flightcrewscheduling.domain.Airport;
import org.optaplanner.examples.flightcrewscheduling.domain.Employee;
import org.optaplanner.examples.flightcrewscheduling.domain.Flight;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightAssignment;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightCrewParametrization;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightCrewSolution;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;

public class FlightCrewSchedulingXlsxFileIO
extends AbstractXlsxSolutionFileIO<FlightCrewSolution> {
    public static final DateTimeFormatter MILITARY_TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmm", Locale.ENGLISH);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlightCrewSolution read(File inputSolutionFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputSolutionFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            FlightCrewSolution flightCrewSolution = new FlightCrewSchedulingXlsxReader(workbook).read();
            return flightCrewSolution;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(FlightCrewSolution solution, File outputSolutionFile) {
        try (FileOutputStream out = new FileOutputStream(outputSolutionFile);){
            Workbook workbook = new FlightCrewSchedulingXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputSolutionFile (" + outputSolutionFile + ") for solution (" + solution + ").", e);
        }
    }

    private static class FlightCrewSchedulingXlsxWriter
    extends AbstractXlsxSolutionFileIO.AbstractXlsxWriter<FlightCrewSolution> {
        private static final Comparator<FlightAssignment> COMPARATOR = Comparator.comparing(a -> a.getFlight().getDepartureUTCDateTime()).thenComparing(a -> a.getFlight().getArrivalUTCDateTime()).thenComparingLong(AbstractPersistable::getId);

        public FlightCrewSchedulingXlsxWriter(FlightCrewSolution solution) {
            super(solution, "org/optaplanner/examples/flightcrewscheduling/solver/flightCrewSchedulingSolverConfig.xml");
        }

        @Override
        public Workbook write() {
            this.writeSetup();
            this.writeConfiguration();
            this.writeSkillList();
            this.writeAirportList();
            this.writeTaxiTimeMaps();
            this.writeEmployeeList();
            this.writeFlightListAndFlightAssignmentList();
            this.writeEmployeesView();
            this.writeScoreView(justificationList -> justificationList.stream().filter(o -> o instanceof FlightAssignment).map(o -> ((FlightAssignment)o).getFlight().toString()).collect(Collectors.joining(", ")));
            return this.workbook;
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 4, false);
            this.nextRow();
            this.nextHeaderCell("Schedule start UTC Date");
            this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(((FlightCrewSolution)this.solution).getScheduleFirstUTCDate()));
            this.nextRow();
            this.nextHeaderCell("Schedule end UTC Date");
            this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(((FlightCrewSolution)this.solution).getScheduleLastUTCDate()));
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint");
            this.nextHeaderCell("Weight");
            this.nextHeaderCell("Description");
            FlightCrewParametrization parametrization = ((FlightCrewSolution)this.solution).getParametrization();
            this.writeLongConstraintParameterLine("Load balance flight duration total per employee", parametrization::getLoadBalanceFlightDurationTotalPerEmployee, "Soft penalty per 0.001 minute difference with the average flight duration total per employee.");
            this.nextRow();
            this.writeIntConstraintParameterLine("Required skill", null, "Hard penalty per missing required skill for a flight assignment");
            this.writeIntConstraintParameterLine("Flight conflict", null, "Hard penalty per 2 flights of an employee that directly overlap");
            this.writeIntConstraintParameterLine("Transfer between two flights", null, "Hard penalty per 2 sequential flights of an employee with no viable transfer from the arrival airport to the departure airport");
            this.writeIntConstraintParameterLine("Employee unavailability", null, "Hard penalty per flight assignment to an employee that is unavailable");
            this.autoSizeColumnsWithHeader();
        }

        private void writeSkillList() {
            this.nextSheet("Skills", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Name");
            for (Skill skill : ((FlightCrewSolution)this.solution).getSkillList()) {
                this.nextRow();
                this.nextCell().setCellValue(skill.getName());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeAirportList() {
            this.nextSheet("Airports", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Code");
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Latitude");
            this.nextHeaderCell("Longitude");
            for (Airport airport : ((FlightCrewSolution)this.solution).getAirportList()) {
                this.nextRow();
                this.nextCell().setCellValue(airport.getCode());
                this.nextCell().setCellValue(airport.getName());
                this.nextCell().setCellValue(airport.getLatitude());
                this.nextCell().setCellValue(airport.getLongitude());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTaxiTimeMaps() {
            this.nextSheet("Taxi time", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Driving time in minutes by taxi between two nearby airports to allow employees to start from a different airport.");
            this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + 20));
            List<Airport> airportList = ((FlightCrewSolution)this.solution).getAirportList();
            this.nextRow();
            this.nextHeaderCell("Airport code");
            for (Airport airport : airportList) {
                this.nextHeaderCell(airport.getCode());
            }
            for (Airport a : airportList) {
                this.nextRow();
                this.nextHeaderCell(a.getCode());
                for (Airport b : airportList) {
                    Long taxiTime = a.getTaxiTimeInMinutesTo(b);
                    if (taxiTime == null) {
                        this.nextCell();
                        continue;
                    }
                    this.nextCell().setCellValue((double)taxiTime.longValue());
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeEmployeeList() {
            this.nextSheet("Employees", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("Unavailability");
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Home airport");
            this.nextHeaderCell("Skills");
            LocalDate firstDate = ((FlightCrewSolution)this.solution).getScheduleFirstUTCDate();
            LocalDate lastDate = ((FlightCrewSolution)this.solution).getScheduleLastUTCDate();
            LocalDate date = firstDate;
            while (date.compareTo(lastDate) <= 0) {
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(date));
                date = date.plusDays(1L);
            }
            for (Employee employee : ((FlightCrewSolution)this.solution).getEmployeeList()) {
                this.nextRow();
                this.nextCell().setCellValue(employee.getName());
                this.nextCell().setCellValue(employee.getHomeAirport().getCode());
                this.nextCell().setCellValue(String.join((CharSequence)", ", employee.getSkillSet().stream().map(Skill::getName).collect(Collectors.toList())));
                LocalDate date2 = firstDate;
                while (date2.compareTo(lastDate) <= 0) {
                    this.nextCell(employee.getUnavailableDaySet().contains(date2) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                    date2 = date2.plusDays(1L);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeFlightListAndFlightAssignmentList() {
            this.nextSheet("Flights", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Flight number");
            this.nextHeaderCell("Departure airport code");
            this.nextHeaderCell("Departure UTC date time");
            this.nextHeaderCell("Arrival airport code");
            this.nextHeaderCell("Arrival UTC date time");
            this.nextHeaderCell("Employee skill requirements");
            this.nextHeaderCell("Employee assignments");
            Map flightToFlightAssignmentMap = ((FlightCrewSolution)this.solution).getFlightAssignmentList().stream().collect(Collectors.groupingBy(FlightAssignment::getFlight, Collectors.toList()));
            for (Flight flight : ((FlightCrewSolution)this.solution).getFlightList()) {
                this.nextRow();
                this.nextCell().setCellValue(flight.getFlightNumber());
                this.nextCell().setCellValue(flight.getDepartureAirport().getCode());
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DATE_TIME_FORMATTER.format(flight.getDepartureUTCDateTime()));
                this.nextCell().setCellValue(flight.getArrivalAirport().getCode());
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DATE_TIME_FORMATTER.format(flight.getArrivalUTCDateTime()));
                List flightAssignmentList = flightToFlightAssignmentMap.get(flight);
                this.nextCell().setCellValue(flightAssignmentList.stream().map(FlightAssignment::getRequiredSkill).map(Skill::getName).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(flightAssignmentList.stream().map(FlightAssignment::getEmployee).map(employee -> employee == null ? "" : employee.getName()).collect(Collectors.joining(", ")));
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeEmployeesView() {
            this.nextSheet("Employees view", 2, 2, true);
            int minimumHour = ((FlightCrewSolution)this.solution).getFlightList().stream().map(Flight::getDepartureUTCTime).map(LocalTime::getHour).min(Comparator.naturalOrder()).orElse(9);
            int maximumHour = ((FlightCrewSolution)this.solution).getFlightList().stream().map(Flight::getArrivalUTCTime).map(LocalTime::getHour).max(Comparator.naturalOrder()).orElse(17);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            LocalDate firstDate = ((FlightCrewSolution)this.solution).getScheduleFirstUTCDate();
            LocalDate lastDate = ((FlightCrewSolution)this.solution).getScheduleLastUTCDate();
            LocalDate date = firstDate;
            while (date.compareTo(lastDate) <= 0) {
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(date));
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + (maximumHour - minimumHour)));
                this.currentColumnNumber += maximumHour - minimumHour;
                date = date.plusDays(1L);
            }
            this.nextRow();
            this.nextHeaderCell("Employee name");
            this.nextHeaderCell("Home airport");
            date = firstDate;
            while (date.compareTo(lastDate) <= 0) {
                for (int hour = minimumHour; hour <= maximumHour; ++hour) {
                    this.nextHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(LocalTime.of(hour, 0)));
                }
                date = date.plusDays(1L);
            }
            Map employeeToFlightAssignmentMap = ((FlightCrewSolution)this.solution).getFlightAssignmentList().stream().filter(flightAssignment -> flightAssignment.getEmployee() != null).collect(Collectors.groupingBy(FlightAssignment::getEmployee, Collectors.toList()));
            for (Employee employee : ((FlightCrewSolution)this.solution).getEmployeeList()) {
                this.nextRow();
                this.nextHeaderCell(employee.getName());
                this.nextHeaderCell(employee.getHomeAirport().getCode());
                List<FlightAssignment> employeeAssignmentList = employeeToFlightAssignmentMap.get(employee);
                if (employeeAssignmentList == null) continue;
                employeeAssignmentList.sort(COMPARATOR);
                LocalDate date2 = firstDate;
                while (date2.compareTo(lastDate) <= 0) {
                    boolean unavailable = employee.getUnavailableDaySet().contains(date2);
                    Map<Integer, List<FlightAssignment>> hourToAssignmentListMap = this.extractHourToAssignmentListMap(employeeAssignmentList, date2);
                    for (int departureHour = minimumHour; departureHour <= maximumHour; ++departureHour) {
                        List<FlightAssignment> flightAssignmentList = hourToAssignmentListMap.get(departureHour);
                        if (flightAssignmentList != null && !flightAssignmentList.isEmpty()) {
                            this.nextCell(unavailable ? this.unavailableStyle : this.defaultStyle).setCellValue(flightAssignmentList.stream().map(FlightAssignment::getFlight).map(flight -> flight.getDepartureAirport().getCode() + MILITARY_TIME_FORMATTER.format(flight.getDepartureUTCTime()) + "\u2192" + flight.getArrivalAirport().getCode() + MILITARY_TIME_FORMATTER.format(flight.getArrivalUTCTime())).collect(Collectors.joining(", ")));
                            int maxArrivalHour = flightAssignmentList.stream().map(a -> a.getFlight().getArrivalUTCTime().getHour()).max(Comparator.naturalOrder()).get();
                            int stretch = maxArrivalHour - departureHour;
                            this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + stretch));
                            this.currentColumnNumber += stretch;
                            departureHour += stretch;
                            continue;
                        }
                        this.nextCell(unavailable ? this.unavailableStyle : this.defaultStyle);
                    }
                    date2 = date2.plusDays(1L);
                }
            }
            this.setSizeColumnsWithHeader(1500);
            this.currentSheet.autoSizeColumn(0);
            this.currentSheet.autoSizeColumn(1);
        }

        private Map<Integer, List<FlightAssignment>> extractHourToAssignmentListMap(List<FlightAssignment> employeeAssignmentList, LocalDate date) {
            HashMap<Integer, List<FlightAssignment>> hourToAssignmentListMap = new HashMap<Integer, List<FlightAssignment>>(employeeAssignmentList.size());
            int previousArrivalHour = -1;
            ArrayList<FlightAssignment> previousFlightAssignmentList = null;
            for (FlightAssignment flightAssignment : employeeAssignmentList) {
                Flight flight = flightAssignment.getFlight();
                if (!flight.getDepartureUTCDate().equals(date)) continue;
                int departureHour = flight.getDepartureUTCTime().getHour();
                int arrivalHour = flight.getArrivalUTCTime().getHour();
                if (previousArrivalHour < departureHour) {
                    previousFlightAssignmentList = new ArrayList<FlightAssignment>(24);
                    hourToAssignmentListMap.put(departureHour, previousFlightAssignmentList);
                    previousArrivalHour = arrivalHour;
                } else {
                    previousArrivalHour = Math.max(previousArrivalHour, arrivalHour);
                }
                previousFlightAssignmentList.add(flightAssignment);
            }
            return hourToAssignmentListMap;
        }
    }

    private static class FlightCrewSchedulingXlsxReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<FlightCrewSolution> {
        private Map<String, Skill> skillMap;
        private Map<String, Employee> nameToEmployeeMap;
        private Map<String, Airport> airportMap;

        public FlightCrewSchedulingXlsxReader(XSSFWorkbook workbook) {
            super(workbook, "org/optaplanner/examples/flightcrewscheduling/solver/flightCrewSchedulingSolverConfig.xml");
        }

        @Override
        public FlightCrewSolution read() {
            this.solution = new FlightCrewSolution();
            this.readConfiguration();
            this.readSkillList();
            this.readAirportList();
            this.readTaxiTimeMaps();
            this.readEmployeeList();
            this.readFlightListAndFlightAssignmentList();
            return (FlightCrewSolution)this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow(false);
            this.readHeaderCell("Schedule start UTC Date");
            ((FlightCrewSolution)this.solution).setScheduleFirstUTCDate(LocalDate.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DAY_FORMATTER));
            this.nextRow(false);
            this.readHeaderCell("Schedule end UTC Date");
            ((FlightCrewSolution)this.solution).setScheduleLastUTCDate(LocalDate.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DAY_FORMATTER));
            this.nextRow(false);
            this.nextRow(false);
            this.readHeaderCell("Constraint");
            this.readHeaderCell("Weight");
            this.readHeaderCell("Description");
            FlightCrewParametrization parametrization = new FlightCrewParametrization();
            parametrization.setId(0L);
            this.readLongConstraintParameterLine("Load balance flight duration total per employee", parametrization::setLoadBalanceFlightDurationTotalPerEmployee, "Soft penalty per 0.001 minute difference with the average flight duration total per employee.");
            this.readIntConstraintParameterLine("Required skill", null, "Hard penalty per missing required skill for a flight assignment");
            this.readIntConstraintParameterLine("Flight conflict", null, "Hard penalty per 2 flights of an employee that directly overlap");
            this.readIntConstraintParameterLine("Transfer between two flights", null, "Hard penalty per 2 sequential flights of an employee with no viable transfer from the arrival airport to the departure airport");
            this.readIntConstraintParameterLine("Employee unavailability", null, "Hard penalty per flight assignment to an employee that is unavailable");
            ((FlightCrewSolution)this.solution).setParametrization(parametrization);
        }

        private void readSkillList() {
            this.nextSheet("Skills");
            this.nextRow(false);
            this.readHeaderCell("Name");
            ArrayList<Skill> skillList = new ArrayList<Skill>(this.currentSheet.getLastRowNum() - 1);
            this.skillMap = new HashMap<String, Skill>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Skill skill = new Skill();
                skill.setId(id++);
                skill.setName(this.nextStringCell().getStringCellValue());
                this.skillMap.put(skill.getName(), skill);
                skillList.add(skill);
            }
            ((FlightCrewSolution)this.solution).setSkillList(skillList);
        }

        private void readAirportList() {
            this.nextSheet("Airports");
            this.nextRow(false);
            this.readHeaderCell("Code");
            this.readHeaderCell("Name");
            this.readHeaderCell("Latitude");
            this.readHeaderCell("Longitude");
            ArrayList<Airport> airportList = new ArrayList<Airport>(this.currentSheet.getLastRowNum() - 1);
            this.airportMap = new HashMap<String, Airport>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Airport airport = new Airport();
                airport.setId(id++);
                airport.setCode(this.nextStringCell().getStringCellValue());
                airport.setName(this.nextStringCell().getStringCellValue());
                airport.setLatitude(this.nextNumericCell().getNumericCellValue());
                airport.setLongitude(this.nextNumericCell().getNumericCellValue());
                this.airportMap.put(airport.getCode(), airport);
                airportList.add(airport);
            }
            ((FlightCrewSolution)this.solution).setAirportList(airportList);
        }

        private void readTaxiTimeMaps() {
            this.nextSheet("Taxi time");
            this.nextRow();
            this.readHeaderCell("Driving time in minutes by taxi between two nearby airports to allow employees to start from a different airport.");
            List<Airport> airportList = ((FlightCrewSolution)this.solution).getAirportList();
            this.nextRow();
            this.readHeaderCell("Airport code");
            for (Airport airport : airportList) {
                this.readHeaderCell(airport.getCode());
            }
            for (Airport a : airportList) {
                a.setTaxiTimeInMinutesMap(new LinkedHashMap<Airport, Long>(airportList.size()));
                this.nextRow();
                this.readHeaderCell(a.getCode());
                for (Airport b : airportList) {
                    XSSFCell taxiTimeCell = this.nextNumericCellOrBlank();
                    if (taxiTimeCell == null) continue;
                    a.getTaxiTimeInMinutesMap().put(b, (long)taxiTimeCell.getNumericCellValue());
                }
            }
        }

        private void readEmployeeList() {
            this.nextSheet("Employees");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("Unavailability");
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Home airport");
            this.readHeaderCell("Skills");
            LocalDate firstDate = ((FlightCrewSolution)this.solution).getScheduleFirstUTCDate();
            LocalDate lastDate = ((FlightCrewSolution)this.solution).getScheduleLastUTCDate();
            LocalDate date = firstDate;
            while (date.compareTo(lastDate) <= 0) {
                this.readHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(date));
                date = date.plusDays(1L);
            }
            ArrayList<Employee> employeeList = new ArrayList<Employee>(this.currentSheet.getLastRowNum() - 2);
            this.nameToEmployeeMap = new HashMap<String, Employee>(this.currentSheet.getLastRowNum() - 2);
            long id = 0L;
            while (this.nextRow()) {
                Employee employee = new Employee();
                employee.setId(id++);
                employee.setName(this.nextStringCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(employee.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The employee name (" + employee.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                String homeAirportCode = this.nextStringCell().getStringCellValue();
                Airport homeAirport = this.airportMap.get(homeAirportCode);
                if (homeAirport == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The employee (" + employee.getName() + ")'s homeAirport (" + homeAirportCode + ") does not exist in the airports (" + this.airportMap.keySet() + ") of the other sheet (Airports).");
                }
                employee.setHomeAirport(homeAirport);
                String[] skillNames = this.nextStringCell().getStringCellValue().split(", ");
                LinkedHashSet<Skill> skillSet = new LinkedHashSet<Skill>(skillNames.length);
                for (String skillName : skillNames) {
                    Skill skill = this.skillMap.get(skillName);
                    if (skill == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The employee (" + employee + ")'s skill (" + skillName + ") does not exist in the skills (" + this.skillMap.keySet() + ") of the other sheet (Skills).");
                    }
                    skillSet.add(skill);
                }
                employee.setSkillSet(skillSet);
                LinkedHashSet<LocalDate> unavailableDaySet = new LinkedHashSet<LocalDate>();
                LocalDate date2 = firstDate;
                while (date2.compareTo(lastDate) <= 0) {
                    XSSFCell cell = this.nextStringCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableDaySet.add(date2);
                    }
                    if (!cell.getStringCellValue().isEmpty()) {
                        throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty.");
                    }
                    date2 = date2.plusDays(1L);
                }
                employee.setUnavailableDaySet(unavailableDaySet);
                employee.setFlightAssignmentSet(new TreeSet<FlightAssignment>());
                this.nameToEmployeeMap.put(employee.getName(), employee);
                employeeList.add(employee);
            }
            ((FlightCrewSolution)this.solution).setEmployeeList(employeeList);
        }

        private void readFlightListAndFlightAssignmentList() {
            this.nextSheet("Flights");
            this.nextRow(false);
            this.readHeaderCell("Flight number");
            this.readHeaderCell("Departure airport code");
            this.readHeaderCell("Departure UTC date time");
            this.readHeaderCell("Arrival airport code");
            this.readHeaderCell("Arrival UTC date time");
            this.readHeaderCell("Employee skill requirements");
            this.readHeaderCell("Employee assignments");
            ArrayList<Flight> flightList = new ArrayList<Flight>(this.currentSheet.getLastRowNum() - 1);
            ArrayList<FlightAssignment> flightAssignmentList = new ArrayList<FlightAssignment>((this.currentSheet.getLastRowNum() - 1) * 5);
            long id = 0L;
            long flightAssignmentId = 0L;
            while (this.nextRow()) {
                Flight flight = new Flight();
                flight.setId(id++);
                flight.setFlightNumber(this.nextStringCell().getStringCellValue());
                String departureAirportCode = this.nextStringCell().getStringCellValue();
                Airport departureAirport = this.airportMap.get(departureAirportCode);
                if (departureAirport == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The flight (" + flight.getFlightNumber() + ")'s departureAirport (" + departureAirportCode + ") does not exist in the airports (" + this.airportMap.keySet() + ") of the other sheet (Airports).");
                }
                flight.setDepartureAirport(departureAirport);
                flight.setDepartureUTCDateTime(LocalDateTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DATE_TIME_FORMATTER));
                String arrivalAirportCode = this.nextStringCell().getStringCellValue();
                Airport arrivalAirport = this.airportMap.get(arrivalAirportCode);
                if (arrivalAirport == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The flight (" + flight.getFlightNumber() + ")'s arrivalAirport (" + arrivalAirportCode + ") does not exist in the airports (" + this.airportMap.keySet() + ") of the other sheet (Airports).");
                }
                flight.setArrivalAirport(arrivalAirport);
                flight.setArrivalUTCDateTime(LocalDateTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DATE_TIME_FORMATTER));
                String[] skillNames = this.nextStringCell().getStringCellValue().split(", ");
                String[] employeeNames = this.nextStringCell().getStringCellValue().split(", ");
                for (int i = 0; i < skillNames.length; ++i) {
                    FlightAssignment flightAssignment = new FlightAssignment();
                    flightAssignment.setId(flightAssignmentId++);
                    flightAssignment.setFlight(flight);
                    flightAssignment.setIndexInFlight(i);
                    Skill requiredSkill = this.skillMap.get(skillNames[i]);
                    if (requiredSkill == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The flight (" + flight.getFlightNumber() + ")'s requiredSkill (" + requiredSkill + ") does not exist in the skills (" + this.skillMap.keySet() + ") of the other sheet (Skills).");
                    }
                    flightAssignment.setRequiredSkill(requiredSkill);
                    if (employeeNames.length > i && !employeeNames[i].isEmpty()) {
                        Employee employee = this.nameToEmployeeMap.get(employeeNames[i]);
                        if (employee == null) {
                            throw new IllegalStateException(this.currentPosition() + ": The flight (" + flight.getFlightNumber() + ")'s employeeAssignment's name (" + employeeNames[i] + ") does not exist in the employees (" + this.nameToEmployeeMap.keySet() + ") of the other sheet (Employees).");
                        }
                        flightAssignment.setEmployee(employee);
                    }
                    flightAssignmentList.add(flightAssignment);
                }
                flightList.add(flight);
            }
            ((FlightCrewSolution)this.solution).setFlightList(flightList);
            ((FlightCrewSolution)this.solution).setFlightAssignmentList(flightAssignmentList);
        }
    }
}

