/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.test.api.score.stream.AbstractAssertion;

public abstract class AbstractConstraintVerifier<Solution_, Assertion extends AbstractAssertion<Solution_, Assertion, Verifier>, Verifier extends AbstractConstraintVerifier<Solution_, Assertion, Verifier>> {
    private final ConstraintStreamScoreDirectorFactory<Solution_> constraintStreamScoreDirectorFactory;

    protected AbstractConstraintVerifier(ConstraintStreamScoreDirectorFactory<Solution_> constraintStreamScoreDirectorFactory) {
        this.constraintStreamScoreDirectorFactory = constraintStreamScoreDirectorFactory;
    }

    protected Constraint getConstraint() {
        return this.constraintStreamScoreDirectorFactory.getConstraints()[0];
    }

    protected abstract Assertion createAssertion(Score<?> var1, Map<String, ConstraintMatchTotal> var2);

    public final Assertion given(Object ... facts) {
        try (ConstraintSession constraintSession = this.constraintStreamScoreDirectorFactory.newConstraintStreamingSession(true, null);){
            Arrays.stream(facts).distinct().forEach(arg_0 -> ((ConstraintSession)constraintSession).insert(arg_0));
            Map constraintMatches = constraintSession.getConstraintMatchTotalMap();
            Assertion Assertion = this.createAssertion(constraintSession.calculateScore(0), constraintMatches);
            return Assertion;
        }
    }

    public final Assertion given(Solution_ solution) {
        try (ConstraintStreamScoreDirector scoreDirector = this.constraintStreamScoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            Map constraintMatches = scoreDirector.getConstraintMatchTotalMap();
            Assertion Assertion = this.createAssertion(scoreDirector.calculateScore(), constraintMatches);
            return Assertion;
        }
    }
}

