/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.test.api.score.stream.ConstraintProviderVerifier;
import org.optaplanner.test.api.score.stream.SingleConstraintVerifier;

public final class ConstraintVerifier<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private ConstraintStreamImplType constraintStreamImplType = ConstraintStreamImplType.DROOLS;

    private ConstraintVerifier(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public static <Solution_> ConstraintVerifier<Solution_> build(Class<Solution_> planningSolutionClass, Class<?> firstPlanningEntityClass, Class<?> ... otherPlanningEntityClasses) {
        Class[] entityClasses = (Class[])Stream.concat(Stream.of(Objects.requireNonNull(firstPlanningEntityClass)), Stream.of(otherPlanningEntityClasses)).toArray(Class[]::new);
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(Objects.requireNonNull(planningSolutionClass), (Class[])entityClasses);
        return new ConstraintVerifier<Solution_>(solutionDescriptor);
    }

    SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public ConstraintVerifier<Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    public SingleConstraintVerifier<Solution_> verifyThat(Function<ConstraintFactory, Constraint> constraintFunction) {
        return new SingleConstraintVerifier(this, Objects.requireNonNull(constraintFunction), this.constraintStreamImplType);
    }

    public ConstraintProviderVerifier<Solution_> verifyThat(ConstraintProvider constraintProvider) {
        return new ConstraintProviderVerifier(this, Objects.requireNonNull(constraintProvider), this.constraintStreamImplType);
    }
}

